unit term;
{terminal interface for TELND, P. Wzietek, 1996}



{this unit implements a 'virtual' terminal the I/O can be easily
 redirected to either WinCrt or Telnet terminal.

two 'object' variables are defined:

     termcrt:  terminal associated with winCRT
     termtel:  remote terminal

     Pterm:    points to the current terminal
}

interface
uses wincrt, windos, wintypes, winprocs, usetelnd, strings;


type
    Tuserproc=procedure;   {user procedure called on "connect" and
                            "rcvdata" events, "rcvdata" is sent when
                            a CR has been pressed on the remote terminal.
                            The function should retrieve data using 'inputline' procedure}

            procedure init_term(password: string; Puserproc: Tuserproc);
            procedure switchtel;  {switch default terminal to telnet}
            procedure switchcrt;  {switch to WinCrt}

type

    terminal = object    {uses WinCRT I/O}

             out: text;  {standard output (use: write(term.out, ...) }

             function keypressed: boolean; virtual;
             function readkey: char; virtual;         {wait for character (CRT readkey)}
             function inputline(var line: string): boolean; virtual;
             procedure clrscr; virtual;             {clear screen}
             procedure clreol; virtual;              {clear from cursor to end of line}
             procedure locate(row, col: word); virtual;  {set cursor at row, col}


             function connected: boolean; virtual;   {always true for CRT}
             function CTS: boolean; virtual; {clear to send, always true for CRT}
             function id: string; virtual;    {terminal name}


             {optional miscellaneous input functions}
             function input_int(var i: integer): boolean; {input an integer}
             function input_re(var r: single): boolean;    {input a real }
             function input_re_at(var r: single; l,c: word): boolean;  {set cursor and input}
             function input_int_at(var i: integer; l,c: word): boolean;

             PRIVATE
             blocking: boolean;  {TRUE when waiting for input, force FALSE to unblock}

             constructor init;

             end;


    terminal_telnet = object(terminal)

             function keypressed: boolean; virtual;
             function readkey: char; virtual;
             function inputline(var line: string): boolean; virtual;
             procedure clrscr; virtual;
             procedure clreol; virtual;
             procedure locate(row, col: word); virtual;

             function connected: boolean; virtual;  {if remote user connected}
             function CTS: boolean; virtual;
             function id: string; virtual;      {returns remote host name or IP}

             PRIVATE
             constructor init;

             end;
var
     termcrt: terminal;
     termtel: terminal_telnet;
     Pterm: ^terminal;


{*************************************}
implementation

const


  wm_teld             = WM_USER + 1;    {TELND message}
  ctrl_E=#5;


var
  hCRTWindow :hWnd;
  OldWndProc : TFarProc;

  cmd_enabled:  boolean;   {when true, 'rcvdata' event is processed}
  cmd_flag:     boolean;
  Pcmdproc:   Tuserproc;


 {*****************************}




procedure switchtel;  {switch default terminal to telnet}
var c: char;
begin
if not termtel.connected then exit;

if not termCRT.blocking then
                begin
                writeln(termtel.out);
                writeln(termtel.out, 'to return back to this menu press <CTRL-E>');
                writeln(termtel.out, 'press <ENTER> to continue...');
                cmd_enabled:=false;
                termtel.readkey;
                Pterm:= @termtel;
                end
   else
                begin
                writeln(termtel.out);
                writeln(termtel.out, 'WARNING:');
                writeln(termtel.out, 'the program is waiting for input from local user');
                writeln(termtel.out, 'press "C" to continue, <ENTER> to go back to the menu');
                cmd_enabled:=false;
                c:=termtel.readkey;
                if (c in ['c', 'C']) and termtel.connected then
                    begin
                    writeln(termtel.out, 'to return back to the menu press <CTRL-E>');
                    Pterm := @termtel;
                    termCRT.blocking:=false; {unblock local term.}
                    end
                  else
                      begin
                      cmd_enabled:=true;
                      termtel.blocking:=false;
                      Pcmdproc;
                      end;
                end;
end;
{*********************}
procedure switchcrt;
begin
termtel.blocking:=false;
Pterm:=@termcrt;
cmd_enabled:=true;
termcrt.clrscr;
end;

{*********************}
procedure init_term(password: string; Puserproc: Tuserproc);
var ps: array[0..255]of char;
begin
strPcopy(ps, password);
Telnetinit(ps, 0);
TelnetAsync(hCRTWindow, wm_teld, mm_line+mm_ctrl);
TelnetSetEcho(em_enabled+em_CRTOCRLF);
cmd_enabled:=true;
Pcmdproc:=Puserproc;

termCRT.init;
termtel.init;

Pterm:= @termCRT;

end;

{****************************************************}
procedure processmsg;
{we use this procedure to make the application 'idle'
when waiting for input from either terminal}

var Msg: Tmsg;
begin
GetMessage(Msg, 0, 0,0);

if Msg.message<>wm_quit then
      begin translatemessage(Msg); dispatchmessage(Msg);end
      else  Postquitmessage(msg.wparam);
end;


{**********  methods of  termCRT ***********}
constructor terminal.init;
begin
assigncrt(out);rewrite(out);
blocking:=false;
end;



function terminal.connected;
begin connected:=true;end;

function terminal.cts;
begin cts:=true; end;

function terminal.id;
begin id:='local'; end;

function terminal.keypressed;
begin; keypressed:=wincrt.keypressed; end;

function terminal.readkey;
begin;
blocking:=true;
while not (wincrt.keypressed or (not blocking)) do processmsg;
if blocking then
   readkey:=wincrt.readkey
 else {forced unblock, readkey will return #0}
   readkey:=#0;
blocking:=false;
end;

function terminal.inputline;
var
    c:char;
begin
line:='';
blocking:=true;

repeat
while not (wincrt.keypressed or (not blocking)) do processmsg;
      if blocking then
          begin
          c:=wincrt.readkey; write(c);
          if c<>#13 then line:=line+c;
          end;
until (not blocking) or (c=#13);

if c=#13 then inputline:=true
         else begin inputline:=false; line:=''; end;
blocking:=false;

end;

procedure terminal.clrscr;
begin wincrt.clrscr; end;

procedure terminal.clreol;
begin wincrt.clreol; end;

procedure terminal.locate;
var c,r:integer;
begin
c:=col-1; r:=row-1;
if c<0 then c:=0; if r<0 then r:=0;
cursorto(c, r);
end;

function terminal.input_int;  {returns true if a valid integer has been entered}
var l: string;
    c,int: integer;
begin
input_int:=false;
if inputline(l) then
   begin
   val(l,int,c);
   if c=0 then begin i:=int; input_int:=true; end;
   end;
end;

function terminal.input_re;    {returns true if a valid real has been entered}
var l: string;
    c: integer;
    re:single;
begin
input_re:=false;
if inputline(l) then
   begin
   val(l,re,c);
   if c=0 then begin r:=re; input_re:=true; end;
   end;
end;

function terminal.input_re_at(var r: single; l,c: word): boolean;
begin
locate(l,c); clreol;
input_re_at:=input_re(r);
end;

function terminal.input_int_at;
begin
locate(l,c); clreol;
input_int_at:=input_int(i);
end;

{******************************************}
                  {terminal_telnet:}

 {*******************************************************************}

{functions to hook the output buffer of a "text" variable}
const
      fbuflen=255;  {max. dos buffer size}

var
    tbuf:array[0..fbuflen]of char; {file IO buffer}

function text_dummy(var f:ttextrec):integer;export;
{do nothing, return IOresult=OK}
begin
text_dummy:=0;
end;


function text_inout(var f:ttextrec):integer;export;
{used only for output: pass the buffer to telnet daemon}

begin
if not TelnetConnected then begin f.bufpos:=0;text_inout:=0; exit; end;

if f.bufpos>0 then
       begin
       tbuf[f.bufpos]:=#0;  {ZT string}
       TelnetSendString(tbuf);
       f.bufpos:=0;
       end;
text_inout:=0;
end;

 {************************}
procedure text_init(var f: text);
begin
assign(f, '');
ttextrec(f).OpenFunc:=@text_dummy;
rewrite(f);

with ttextrec(f) do
     begin
    Mode:=fmOutput;        {write-only mode}
    BufSize:= fbuflen;
    BufPos:= 0;
    BufEnd:=0;
    BufPtr:=@tbuf;
    OpenFunc:=@text_dummy;
    InOutFunc:=@text_inout;
    FlushFunc:=@text_inout;
    CloseFunc:=@text_dummy;
    end;
 end;
{***************************************}
constructor terminal_telnet.init;

begin
text_init(out); {assign standard output to telnet}
blocking:=false;
end;

function terminal_telnet.connected;
begin connected:=TelnetConnected; end;


function terminal_telnet.cts;
begin cts:=TelnetCTS; end;

function terminal_telnet.id;
var ps: array[0..255]of char;
begin
TelnetRemoteHost(ps);
if strlen(ps)=0 then TelnetRemoteIP(ps);
id:=strpas(ps);end;

function terminal_telnet.keypressed;
begin;
write(#0); {this will yield control to the system in case one uses a 'repeat until keypressed' loop}
keypressed:=(TelnetPendingInput<>0);
end;

function terminal_telnet.readkey;
var pc: array[0..1]of char;
begin;
blocking:=true;
while not (self.keypressed or (not blocking)) do processmsg;

if self.keypressed then if TelnetInputChar(pc) then readkey:=pc[0]
 else {forced unblock}
   readkey:=#0;

blocking:=false;
end;

function terminal_telnet.inputline;
var pl:array[0..255]of char;

begin
blocking:=true;

while not ((TelnetPendingInput>0) or (not blocking)) do processmsg;

if TelnetPendingInput>0 then
       begin
       TelnetInputLine(pl);
       line:=strpas(pl);
       inputline:=true;
       end
  else
      begin line:=''; inputline:=false; end;
blocking:=false;
end;


procedure terminal_telnet.clrscr;
begin TelnetVTClearScreen; end;

procedure terminal_telnet.clreol;
begin
TelnetVTsavecursor;
TelnetVTeraseline;
TelnetVTrestorecursor;
end;

procedure terminal_telnet.locate;
begin
TelnetVTlocate(row, col);
end;

{*******************************************}
{response to TELND events}

procedure event_disconnect;
{response to close connection event}
begin
Pterm:= @termCRT;
termtel.blocking:=false;
cmd_enabled:=true;
end;

procedure event_connect;
begin
writeln(termtel.out, 'Hello ', termtel.id);
Pcmdproc;  {display main menu}
end;

procedure event_ctrle;
{response to ctrl-E. event:  return to asynchronous mode}
begin
switchcrt;
termCRT.blocking:=false;
Pcmdproc;  { redisplay main menu }
end;

procedure event_data;
begin
Pcmdproc;
end;


{***********************************}
function WindowProc(Window:HWnd; Message,wParam:Word; lParam:LongInt) : LongInt; export;
begin

if Message=wm_teld then
       begin
             case wParam of
             TDEV_connect :    event_connect;
             TDEV_disconnect:  event_disconnect;
             TDEV_ctrlchar:       if chr(lparam)=ctrl_E then event_ctrlE;
             TDEV_rcvdata:      if cmd_enabled then
                                if not cmd_flag
                                    then begin
                                     cmd_flag:=true; event_data; cmd_flag:=false;
                                        end
                         {else defer processing, to prevent reentrant call of event_command}
                                    else PostMessage(Window, Message,wParam, lParam);

             end;
       WindowProc:=DefWindowProc(Window, Message, wParam, lParam);
       end
  else
  {for all other messages call default windowproc }
  WindowProc := CallWindowProc(OldWndProc, Window, Message, wParam, lParam);
end;

{***********************************}


{***********************************}



begin
{init wincrt: }
  InitWinCrt;
  hCRTWindow := GetActiveWindow;
 {set WindowProc as new window processing procedure}
  Longint(OldWndProc):= SetWindowLong (hCRTWindow, GWL_WndProc, LongInt (@WindowProc));

  cmd_enabled:=true;
end.