/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import org.nakedobjects.basicgui.view.CollectionViewer;
import org.nakedobjects.basicgui.view.DisplayState;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.TextStyle;
import org.nakedobjects.basicgui.view.ViewBorder;
import org.nakedobjects.basicgui.view.ViewColor;

public class InternalListBorder
extends ViewBorder {
    protected static final int IMAGE_LABEL_GAP = 6;

    public Insets getBorderInsets(ObjectViewer objectViewer) {
        FontMetrics fontMetrics = TextStyle.getStyle(1).getMetrics();
        return new Insets(0, 0, fontMetrics.getHeight() + fontMetrics.getDescent() * 2, 0);
    }

    public void paint(Graphics graphics, Rectangle rectangle, ObjectViewer objectViewer) {
        int n = rectangle.x;
        int n2 = rectangle.height;
        DisplayState displayState = objectViewer.getDisplayState();
        if (displayState.isPossibleDrop()) {
            graphics.setColor(ViewColor.objectCanDrop);
        } else if (displayState.isInvalidDrop()) {
            graphics.setColor(ViewColor.objectCantDrop);
        } else {
            graphics.setColor(ViewColor.outlineNormal);
        }
        FontMetrics fontMetrics = TextStyle.getStyle(1).getMetrics();
        graphics.fillOval(n + 2, n2 - 12 - fontMetrics.getDescent() * 2, 12, 12);
        String string = objectViewer instanceof CollectionViewer ? objectViewer.typeName() : "Object";
        graphics.drawString(string, n + 16 + 6, n2 - 2 - fontMetrics.getDescent() * 2);
    }
}

