/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.distribution.ObjectRequest;
import org.nakedobjects.object.distribution.ObjectUpdateMessage;
import org.nakedobjects.object.distribution.ProxyObjectStore;
import org.nakedobjects.object.distribution.Server;
import org.nakedobjects.object.distribution.ServerRequestException;
import org.nakedobjects.object.distribution.UpdateMessageException;

class DataForObjectRequest
extends ObjectRequest {
    private static final long serialVersionUID = 1L;

    public DataForObjectRequest(NakedObject nakedObject) {
        super(nakedObject);
    }

    void generateResponse(Server server) {
        try {
            NakedObjectStore nakedObjectStore = server.getObjectStore();
            this.response = nakedObjectStore.getObject(this.getOid());
            NakedObject nakedObject = nakedObjectStore.getObject(this.getOid());
            try {
                this.response = new ObjectUpdateMessage(nakedObject);
            }
            catch (UpdateMessageException updateMessageException) {
                this.response = new ServerRequestException(updateMessageException);
            }
        }
        catch (ObjectStoreException objectStoreException) {
            this.response = objectStoreException;
        }
    }

    public String toString() {
        return "GetObjectData [" + this.getOid() + "]";
    }

    public void update(ProxyObjectStore proxyObjectStore) throws ObjectStoreException, UpdateMessageException {
        this.sendRequest();
        ((ObjectUpdateMessage)this.response).update(proxyObjectStore);
    }
}

