/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.distribution.ObjectRequest;
import org.nakedobjects.object.distribution.Server;
import org.nakedobjects.object.distribution.ServerRequestException;
import org.nakedobjects.object.reflect.Association;

public class GetAssociationRequest
extends ObjectRequest {
    private static final long serialVersionUID = 1L;
    private String name;

    public GetAssociationRequest(NakedObject nakedObject, Association association) {
        super(nakedObject);
        this.name = association.getName();
    }

    void generateResponse(Server server) {
        try {
            NakedObjectStore nakedObjectStore = server.getObjectStore();
            NakedObject nakedObject = nakedObjectStore.getObject(this.getOid());
            Association association = (Association)nakedObject.getNakedClass().getField(this.name);
            if (association == null) {
                throw new ServerRequestException("ObjectAttributeMessage has invalid Field: " + this.name);
            }
            this.response = association.get(nakedObject);
        }
        catch (ObjectStoreException objectStoreException) {
            this.response = objectStoreException;
        }
    }

    public NakedObject getAttribute() throws ObjectStoreException {
        this.sendRequest();
        return (NakedObject)this.response;
    }

    public String toString() {
        return "GetObjectAttribute [" + this.name + "]";
    }
}

