/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.value;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.object.Naked;
import org.nakedobjects.object.Title;
import org.nakedobjects.object.ValueParseException;
import org.nakedobjects.object.value.Magnitude;

public class Money
extends Magnitude
implements Externalizable {
    private static final NumberFormat CURRENCY_FORMAT = NumberFormat.getCurrencyInstance();
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();
    private boolean isNull;
    private double amount;

    public Money() {
        this.amount = 0.0;
        this.isNull = false;
    }

    public Money(Money money) {
        this.amount = money.amount;
    }

    public void add(Money money) {
        this.checkCanOperate();
        money.checkCanOperate();
        this.amount += money.amount;
    }

    public void clear() {
        this.isNull = true;
    }

    public void copyObject(Naked naked) {
        if (!(naked instanceof Money)) {
            throw new IllegalArgumentException("Can only copy the value of  a Currency object");
        }
        Money money = (Money)naked;
        this.isNull = money.isNull;
        this.amount = money.amount;
    }

    public void divideBy(double d) {
        this.checkCanOperate();
        this.amount /= d;
    }

    public double doubleValue() {
        return this.amount;
    }

    public float floatValue() {
        this.checkCanOperate();
        return (float)this.amount;
    }

    public String getObjectHelpText() {
        return "A Currency object stored as dollars/cents, pounds/pence, euro/cents.";
    }

    public int intValue() {
        this.checkCanOperate();
        return (int)this.amount;
    }

    public boolean isEmpty() {
        return this.isNull;
    }

    public boolean isEqualTo(Magnitude magnitude) {
        if (magnitude instanceof Money) {
            if (this.isNull) {
                return magnitude.isEmpty();
            }
            return ((Money)magnitude).amount == this.amount;
        }
        throw new IllegalArgumentException("Parameter must be of type Money");
    }

    public boolean isLessThan(Magnitude magnitude) {
        if (magnitude instanceof Money) {
            return !this.isEmpty() && !magnitude.isEmpty() && this.amount < ((Money)magnitude).amount;
        }
        throw new IllegalArgumentException("Parameter must be of type Money");
    }

    public boolean isNegative() {
        this.checkCanOperate();
        return this.amount < 0.0;
    }

    public long longValue() {
        this.checkCanOperate();
        return (long)this.amount;
    }

    public void multiplyBy(double d) {
        this.checkCanOperate();
        this.amount *= d;
    }

    public void parse(String string) throws ValueParseException {
        if (string.trim().equals("")) {
            this.clear();
        } else {
            try {
                this.setValue(CURRENCY_FORMAT.parse(string).doubleValue());
            }
            catch (ParseException parseException) {
                System.out.println(string);
                try {
                    this.setValue(NUMBER_FORMAT.parse(string).doubleValue());
                }
                catch (ParseException parseException2) {
                    throw new ValueParseException(parseException2, "Invalid number " + string);
                }
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.amount = objectInput.readDouble();
    }

    public void reset() {
        this.amount = 0.0;
        this.isNull = false;
    }

    public void setValue(double d) {
        this.amount = d;
        this.isNull = false;
    }

    public void setValue(Money money) {
        this.amount = money.amount;
        this.isNull = false;
    }

    public short shortValue() {
        this.checkCanOperate();
        return (short)this.amount;
    }

    public void subtract(Money money) {
        this.checkCanOperate();
        money.checkCanOperate();
        this.amount -= money.amount;
    }

    public Title title() {
        return new Title(this.isEmpty() ? "" : CURRENCY_FORMAT.format(this.amount));
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.amount);
    }

    public void restoreString(String string) {
        this.setValue(Double.valueOf(string));
    }

    public String saveString() {
        return String.valueOf(this.doubleValue());
    }
}

