/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class Parser {
    private static String properties = "org/apache/tools/ant/parser.properties";

    public static Parser getParser(Project project) throws BuildException {
        String name;
        InputStream in = project.getClass().getResourceAsStream("parser.properties");
        if (in == null) {
            throw new BuildException("Cannot find properties file");
        }
        try {
            Properties prop = new Properties();
            prop.load(in);
            name = prop.getProperty("parser");
            if (name == null) {
                throw new BuildException("Parser name not found");
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Cannot load properties file");
        }
        try {
            return (Parser)Class.forName(name).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException("Class " + name + " cannot be found");
        }
        catch (InstantiationException instantiationException) {
            throw new BuildException("Class " + name + " cannot be instantiated");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BuildException("Class " + name + " cannot be accessed");
        }
        catch (ClassCastException classCastException) {
            throw new BuildException("Class " + name + " doesn't extend Parser");
        }
    }

    public abstract Document parse(File var1) throws SAXException, IOException;
}

