/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.util.FileUtil;
import org.apache.tomcat.util.RequestUtil;
import org.apache.tomcat.util.StringManager;

public class HttpServletRequestFacade
implements HttpServletRequest {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private Request request;
    private boolean usingStream = false;
    private boolean usingReader = false;

    public HttpServletRequestFacade(Request request) {
        this.request = request;
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public String getContextPath() {
        return this.request.getContext().getPath();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public long getDateHeader(String name) {
        String value = this.request.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long date = RequestUtil.toDate(value);
        if (date == -1L) {
            String msg = this.sm.getString("httpDate.pe", value);
            throw new IllegalArgumentException(msg);
        }
        return date;
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public Enumeration getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            String msg = this.sm.getString("reqfac.getinstream.ise");
            throw new IllegalStateException(msg);
        }
        this.usingStream = true;
        return this.request.getInputStream();
    }

    public int getIntHeader(String name) throws NumberFormatException {
        String value = this.request.getHeader(name);
        if (value == null) {
            return -1;
        }
        int valueInt = Integer.parseInt(value);
        return valueInt;
    }

    public Locale getLocale() {
        return (Locale)this.getLocales().nextElement();
    }

    public Enumeration getLocales() {
        return RequestUtil.getLocales(this);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.request.getParameterValues(name);
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public BufferedReader getReader() throws IOException {
        if (this.usingStream) {
            String msg = this.sm.getString("reqfac.getreader.ise");
            throw new IllegalStateException(msg);
        }
        this.usingReader = true;
        return this.request.getReader();
    }

    public String getRealPath(String name) {
        return this.request.getContext().getRealPath(name);
    }

    public Request getRealRequest() {
        return this.request;
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/") && (path = FileUtil.catPath(this.request.getLookupPath(), path)) == null) {
            return null;
        }
        return this.request.getContext().getRequestDispatcher(path);
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public HttpSession getSession() {
        return this.request.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }
}

