/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.util.StringManager;

public class ServletContextFacade
implements ServletContext {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private ContextManager contextM;
    private Context context;

    ServletContextFacade(ContextManager server, Context context) {
        this.contextM = server;
        this.context = context;
    }

    public Object getAttribute(String name) {
        return this.context.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.context.getAttributeNames();
    }

    public ServletContext getContext(String path) {
        return this.context.getContext(path).getFacade();
    }

    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.context.getInitParameterNames();
    }

    public int getMajorVersion() {
        return 2;
    }

    public String getMimeType(String filename) {
        return this.context.getMimeMap().getContentTypeFor(filename);
    }

    public int getMinorVersion() {
        return 2;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.context.getNamedDispatcher(name);
    }

    public Context getRealContext() {
        return this.context;
    }

    public String getRealPath(String path) {
        return this.context.getRealPath(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.context.getRequestDispatcher(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        InputStream is = null;
        try {
            URL url = this.getResource(path);
            URLConnection con = url.openConnection();
            con.connect();
            is = con.getInputStream();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {}
        return is;
    }

    public String getServerInfo() {
        return this.context.getEngineHeader();
    }

    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    public Enumeration getServletNames() {
        Vector v = new Vector();
        return v.elements();
    }

    public Enumeration getServlets() {
        Vector v = new Vector();
        return v.elements();
    }

    public void log(Exception e, String msg) {
        this.log(msg, e);
    }

    public void log(String msg) {
        this.context.logServlet(msg, null);
    }

    public void log(String msg, Throwable t) {
        this.context.logServlet(msg, t);
    }

    public void removeAttribute(String name) {
        this.context.removeAttribute(name);
    }

    public void setAttribute(String name, Object object) {
        this.context.setAttribute(name, object);
    }
}

