/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.shell;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tomcat.shell.Admin;
import org.apache.tomcat.shell.StartupException;
import org.apache.tomcat.shell.deployment.Config;
import org.apache.tomcat.util.StringManager;

public class Shutdown {
    private StringManager sm;

    static {
        String warPackage = "org.apache.tomcat.protocol";
        String protocolKey = "java.protocol.handler.pkgs";
        String protocolHandlers = System.getProperties().getProperty(protocolKey);
        ((Hashtable)System.getProperties()).put(protocolKey, protocolHandlers == null ? warPackage : String.valueOf(protocolHandlers) + "|" + warPackage);
    }

    public Shutdown(String[] args) throws StartupException {
        block12: {
            this.sm = StringManager.getManager("org.apache.tomcat.shell");
            Config config = this.getConfig(args);
            if (config == null) {
                return;
            }
            String portStr = null;
            if (config.isArg("adminport")) {
                portStr = (String)config.getConfig().getAttribute("adminPort");
            } else {
                Properties props = this.getProperties();
                portStr = props.getProperty("admin.port");
            }
            Registry registry = this.getRegistry(portStr);
            String[] services = this.getServices(registry);
            int counter = 0;
            int i = 0;
            while (i < services.length) {
                String service = services[i];
                if (service.startsWith("service:")) {
                    boolean exit = ++counter == services.length;
                    try {
                        ((Admin)registry.lookup(service)).stopService(exit);
                        registry.unbind(service);
                    }
                    catch (Exception e) {
                        System.out.println(this.sm.getString("shutdown.service.e"));
                        System.out.println(e.toString());
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            services = this.getServices(registry);
            if (services.length != 0) break block12;
            File f = null;
            try {
                f = new File("serverlog.txt");
            }
            catch (NullPointerException nullPointerException) {
                System.out.println(this.sm.getString("shutdown.log.npe", "conf/server.xml"));
            }
            try {
                if (f.exists() && f.isFile()) {
                    f.delete();
                }
            }
            catch (SecurityException securityException) {
                System.out.println(this.sm.getString("shutdown.log.se", "serverlog.txt"));
            }
        }
    }

    private Config getConfig(String[] args) throws StartupException {
        Config config = new Config(args);
        System.out.println(this.sm.getString("startup.banner"));
        if (config.isArg("help")) {
            System.out.println(this.sm.getString("startup.help"));
            System.out.println();
            return null;
        }
        String configFile = "conf/server.xml";
        if (config.isArg("config")) {
            configFile = config.getArg("config");
        }
        config.loadConfig(configFile);
        return config;
    }

    private Properties getProperties() {
        Properties properties;
        block6: {
            properties = new Properties();
            File f = null;
            try {
                f = new File("serverlog.txt");
            }
            catch (NullPointerException nullPointerException) {
                System.out.println(this.sm.getString("shutdown.log.npe", "conf/server.xml"));
            }
            if (f == null) break block6;
            try {
                FileInputStream fis = new FileInputStream(f);
                properties.load(fis);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(this.sm.getString("shutdown.log.fnfe", "serverlog.txt"));
            }
            catch (SecurityException securityException) {
                System.out.println(this.sm.getString("shutdown.log.se", "serverlog.txt"));
            }
            catch (IOException iOException) {
                System.out.println(this.sm.getString("shutdown.log.ioe", "serverlog.txt"));
            }
        }
        return properties;
    }

    private Registry getRegistry(String portStr) throws StartupException {
        Registry registry = null;
        int port = -1;
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException numberFormatException) {
            String msg = this.sm.getString("shutdown.setport.nfe", portStr);
            throw new StartupException(msg);
        }
        try {
            registry = LocateRegistry.getRegistry(port);
        }
        catch (Exception exception) {
            String msg = this.sm.getString("shutdown.registry.e", portStr);
            throw new StartupException(msg);
        }
        return registry;
    }

    private String[] getServices(Registry registry) throws StartupException {
        String[] services = null;
        try {
            services = registry.list();
        }
        catch (AccessException accessException) {
            String msg = this.sm.getString("shutdown.registry.ae");
            throw new StartupException(msg);
        }
        catch (RemoteException remoteException) {
            String msg = this.sm.getString("shutdown.registry.re");
            throw new StartupException(msg);
        }
        return services;
    }

    public static void main(String[] args) {
        try {
            new Shutdown(args);
        }
        catch (StartupException e) {
            System.out.println(e.getMessage());
        }
    }
}

