/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.shell;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.InterceptorAdapter;
import org.apache.tomcat.core.LifecycleInterceptor;
import org.apache.tomcat.core.ServerConnector;
import org.apache.tomcat.core.ServiceInterceptor;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.server.HttpServer;
import org.apache.tomcat.server.HttpServerException;
import org.apache.tomcat.shell.AdminImpl;
import org.apache.tomcat.shell.Constants;
import org.apache.tomcat.shell.StartupException;
import org.apache.tomcat.shell.deployment.Config;
import org.apache.tomcat.shell.deployment.ConnectorConfig;
import org.apache.tomcat.shell.deployment.ContextConfig;
import org.apache.tomcat.shell.deployment.ContextManagerConfig;
import org.apache.tomcat.shell.deployment.ServerConfig;
import org.apache.tomcat.util.StringManager;

public class Startup {
    boolean isRmi = false;
    protected StringManager sm = StringManager.getManager("org.apache.tomcat.shell");

    static {
        String warPackage = "org.apache.tomcat.protocol";
        String protocolKey = "java.protocol.handler.pkgs";
        String protocolHandlers = System.getProperties().getProperty(protocolKey);
        ((Hashtable)System.getProperties()).put(protocolKey, protocolHandlers == null ? warPackage : String.valueOf(protocolHandlers) + "|" + warPackage);
    }

    public void checkClassDependencies() {
        int i = 0;
        while (i < Constants.REQUIRED_CLASSES.length) {
            String clazz = Constants.REQUIRED_CLASSES[i];
            try {
                Class.forName(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String msg = this.sm.getString("startup.classes.cnfe", clazz);
                System.out.println("warning: " + msg);
            }
            ++i;
        }
    }

    public void configure(String[] args) throws StartupException {
        Config config = this.getConfig(args);
        if (config == null) {
            return;
        }
        this.checkClassDependencies();
        ServerConfig serverConfig = config.getServerConfig();
        Registry registry = null;
        if (this.isRmi) {
            registry = this.createRegistry(serverConfig.getAdminPort());
        }
        Enumeration contextManagers = serverConfig.getContextManagers();
        while (contextManagers.hasMoreElements()) {
            String msg;
            ContextManagerConfig contextManagerConfig = (ContextManagerConfig)contextManagers.nextElement();
            ContextManager contextManager = new ContextManager();
            Enumeration contexts = contextManagerConfig.getContextConfigs();
            while (contexts.hasMoreElements()) {
                ContextConfig contextConfig = (ContextConfig)contexts.nextElement();
                Context context = new Context();
                context.setContextManager(contextManager);
                context.setPath(contextConfig.getPath());
                context.setDocumentBase(contextConfig.getDocumentBase());
                try {
                    contextManager.addContext(context);
                }
                catch (TomcatException ex) {
                    ex.printStackTrace();
                }
                context.setSessionTimeOut(contextConfig.getDefaultSessionTimeOut());
                context.setIsWARExpanded(contextConfig.isWARExpanded());
                context.setIsWARValidated(contextConfig.isWARValidated());
                context.setWorkDirPersistent(contextConfig.isWorkDirPersistent());
                context.setIsWARValidated(contextConfig.isWARValidated());
                Enumeration e = contextConfig.getServiceInterceptors();
                while (e.hasMoreElements()) {
                    InterceptorAdapter.addServiceInterceptor(context, (ServiceInterceptor)e.nextElement());
                }
                Enumeration e2 = contextConfig.getLifecycleInterceptors();
                while (e2.hasMoreElements()) {
                    LifecycleInterceptor interceptor = (LifecycleInterceptor)e2.nextElement();
                    InterceptorAdapter.addInitInterceptor(context, interceptor);
                    InterceptorAdapter.addDestroyInterceptor(context, interceptor);
                }
            }
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(contextManagerConfig.getINet());
            }
            catch (UnknownHostException unknownHostException) {
                String msg2 = this.sm.getString("startup.setinit.uhe1", contextManagerConfig.getINet());
                System.out.println(msg2);
            }
            try {
                HttpServer server = new HttpServer(contextManagerConfig.getPort(), inetAddress, contextManagerConfig.getHostName(), contextManager);
                Enumeration conE = contextManagerConfig.getConnectorConfigs();
                while (conE.hasMoreElements()) {
                    ConnectorConfig conC = (ConnectorConfig)conE.nextElement();
                    String cn = conC.getClassName();
                    ServerConnector conn = null;
                    try {
                        Class<?> c = Class.forName(cn);
                        conn = (ServerConnector)c.newInstance();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    Enumeration props = conC.getParameterKeys();
                    while (props.hasMoreElements()) {
                        String k = (String)props.nextElement();
                        String v = (String)conC.getParameter(k);
                        conn.setProperty(k, v);
                    }
                    server.addConnector(conn);
                }
                if (registry != null) {
                    registry.bind("service:" + server.getPort(), new AdminImpl(server));
                }
                server.start();
            }
            catch (HttpServerException hse) {
                msg = this.sm.getString("startup.server.hse");
                System.out.println(msg);
                hse.printStackTrace();
                throw new StartupException();
            }
            catch (RemoteException re) {
                msg = this.sm.getString("startup.server.re");
                System.out.println(msg);
                re.printStackTrace();
                throw new StartupException();
            }
            catch (AlreadyBoundException abe) {
                msg = this.sm.getString("startup.server.abe");
                System.out.println(msg);
                abe.printStackTrace();
                throw new StartupException();
            }
        }
    }

    protected void createLog(int port) {
        block7: {
            File f = null;
            try {
                f = new File("serverlog.txt");
            }
            catch (NullPointerException nullPointerException) {
                System.out.println(this.sm.getString("startup.log.npe", "conf/server.xml"));
            }
            if (f == null) break block7;
            try {
                if (f.exists() && f.isFile()) {
                    f.delete();
                }
            }
            catch (SecurityException securityException) {
                System.out.println(this.sm.getString("startup.log.se", "conf/server.xml"));
            }
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                bw.write("admin.port:" + port);
                bw.newLine();
                bw.close();
            }
            catch (IOException iOException) {
                System.out.println(this.sm.getString("startup.log.ioe", "conf/server.xml"));
            }
        }
    }

    protected Registry createRegistry(int port) throws StartupException {
        String msg;
        Registry registry = null;
        int numberAttempts = 0;
        if (port == 0) {
            return null;
        }
        if (port < 0) {
            port = this.newPort();
        }
        while (true) {
            msg = null;
            try {
                registry = LocateRegistry.createRegistry(port);
                this.createLog(port);
            }
            catch (Exception exception) {
                msg = this.sm.getString("startup.registry.e");
            }
            if (registry != null || numberAttempts++ >= 5) break;
            port = this.newPort();
        }
        if (registry == null) {
            throw new StartupException(msg);
        }
        return registry;
    }

    private Config getConfig(String[] args) throws StartupException {
        Config config = new Config(args);
        System.out.println(this.sm.getString("startup.banner"));
        if (config.isArg("help")) {
            System.out.println(this.sm.getString("startup.help"));
            System.out.println();
            return null;
        }
        String configFile = "conf/server.xml";
        if (config.isArg("config")) {
            configFile = config.getArg("config");
        }
        config.loadConfig(configFile);
        return config;
    }

    public static void main(String[] args) {
        try {
            Startup start = new Startup();
            start.configure(args);
        }
        catch (StartupException startupException) {
            System.exit(1);
        }
    }

    protected int newPort() {
        Random r = new Random();
        double mul = r.nextDouble();
        int min = 2048;
        int max = 8192;
        return (int)Math.round((double)min + mul * (double)(max - min));
    }
}

