<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">


<HTML>
<HEAD>
     <TITLE>Product Page for most used items of <xsl:value-of select="MSI/CACHEINFO/SUPPLIERNAME"/></TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>

<!-- Include this in every page for allowing the colors and attributes to be set -->
<BODY>



<!-- Page Specific Data -->
<!-- ***************************************************************************************** -->

<CENTER><H1>Most used products from <xsl:value-of select="MSI/CACHEINFO/SUPPLIERNAME"/></H1></CENTER><P></P>
<P></P>

<FORM METHOD="POST">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>

<TABLE>
	
		<TR>
			<TH>Quanity</TH>
			<TH>Item ID</TH>
			<TH>Item Description</TH>
			<TH>Price</TH>
			<TH>Last Order Amount</TH>
			<TH>Last Order Date</TH>
		</TR>
		<xsl:for-each select="MSI/CACHEINFO/ITEMCACHE/CompanyItemCacheTable">
		<xsl:sort select="i2" data-type="text" order="ascending"/>
			<TR>
			    <xsl:choose>
			    <xsl:when test="position() mod 2 = 1">
		   	    <xsl:attribute name="CLASS">ODDROW</xsl:attribute>
			    </xsl:when>
			    <xsl:otherwise>
				    <xsl:attribute name="CLASS">EVENROW</xsl:attribute>
			    </xsl:otherwise>
			    </xsl:choose>			

				<TD><INPUT SIZE="3">
					<xsl:attribute name="NAME">quan<xsl:value-of select="c1"/></xsl:attribute>
				</INPUT></TD>

				<TD><xsl:value-of select="i2"/></TD>
				<TD><xsl:value-of select="i3"/></TD>
				<TD><xsl:value-of select="i4"/></TD>
				<TD><xsl:value-of select="i6"/></TD>
				<TD><xsl:value-of select="i7"/></TD>

				<INPUT TYPE="HIDDEN">
					<xsl:attribute name="NAME">item<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="i2"/></xsl:attribute>
				</INPUT>

				<INPUT TYPE="HIDDEN">
					<xsl:attribute name="NAME">price<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="i4"/></xsl:attribute>
				</INPUT>

				<INPUT TYPE="HIDDEN">
					<xsl:attribute name="NAME">desc<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="i3"/></xsl:attribute>
				</INPUT>

			</TR>
		</xsl:for-each>
</TABLE>

<INPUT type="hidden" name="disValue" value="791"></INPUT>
<INPUT type="hidden" NAME="TOTALITEMS"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/CACHEINFO/ITEMCACHE/FOOTER/TOTALCOUNT"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="COMPANYID"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/CACHEINFO/SUPPLIERID"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="COMPANYNAME"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/CACHEINFO/SUPPLIERNAME"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="PONUMBER"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/CACHEINFO/PONUMBER"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="CONNECTION"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/CACHEINFO/CONNECTION"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="CUSTOMERID"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/CACHEINFO/CUSTOMERID"/></xsl:attribute></INPUT>

<INPUT TYPE="SUBMIT" NAME="ADD" VALUE="Add Products"></INPUT><xsl:text> </xsl:text>
<INPUT TYPE="RESET" VALUE="Undo Changes"></INPUT></FORM><P></P>


</BODY></HTML>

</xsl:template>
</xsl:stylesheet>
