<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">
  <xsl:template match="/">


<HTML>
<HEAD>
     <TITLE>Pay Rep</TITLE>
</HEAD>

<!-- Include this in every page for allowing the colors and attributes to be set -->
<BODY>

<!-- End of Include section -->



<!-- Page Specific Data -->
<!-- ***************************************************************************************** -->


<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[
function printReport() {
   
   window.print();
}
]]>
</xsl:comment>
</SCRIPT>

<xsl:script>
<![CDATA[ 
    function Total(invoice)
    {
      items = invoice.selectNodes("MSI/COMINFO/POComTable");
      var sum2 = 0;
      
      var item = items.nextNode();		
      while (item)
      {
        var price = item.selectSingleNode("i7").nodeTypedValue;
        sum2 += price*1;
	item = items.nextNode();
      }
      
      return sum2;
    }




   ]]> 
 
</xsl:script> 



<TABLE>

<TR>
<TD>Check Number:</TD>
<TD><xsl:value-of select="MSI/CHECKNUM"/></TD>
</TR>

<TR>
<TD>Date:</TD>
<TD><xsl:value-of select="MSI/DATE"/></TD>
</TR>

<TR>
<TD>Rep:</TD>
<TD><xsl:value-of select="MSI/UserInfo/UserTable/i1"/> <xsl:value-of select="MSI/UserInfo/UserTable/i2"/></TD>
</TR>

<TR>
<TD>Amount:</TD>
<TD><xsl:eval>formatNumber(Total(this), "$#,##0.00")</xsl:eval></TD>
</TR>

</TABLE>


<P></P>


<TABLE>
		<TR>
			<TD><b>PO #</b></TD>
			<TD><b>Recevied on</b></TD>
			<TD><b>Commission</b></TD>
			<TD><b>Notes</b></TD>
		</TR>
		
		<xsl:for-each select="MSI/COMINFO/POComTable" order-by="i2">
			<TR>
				<TD><xsl:value-of select="i3"/></TD>
				<TD><xsl:value-of select="i2"/></TD>
				<TD>$<xsl:value-of select="i7"/></TD>
				<TD><xsl:value-of select="i10"/></TD>
				
			</TR>
		</xsl:for-each>
</TABLE>

<P></P>
<BUTTON NAME="PRINT" VALUE="PRINT" onClick="printReport();">Print Report</BUTTON>


</BODY></HTML>

</xsl:template>
</xsl:stylesheet>

