<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">
  <xsl:template match="/">


<HTML>
<HEAD>
     <TITLE>Product Page for <xsl:value-of select="MSI/FULLRESULT/SUPPLIER/SUPPLIER_NAME"/></TITLE>
</HEAD>

<!-- Include this in every page for allowing the colors and attributes to be set -->
<BODY onLoad="reCalc();">
<xsl:attribute name="BGCOLOR"><xsl:value-of select="MSI/LAYOUT/BGCOLOR"/></xsl:attribute>
<xsl:attribute name="TEXT"><xsl:value-of select="MSI/LAYOUT/TEXT"/></xsl:attribute>
<xsl:attribute name="LINK"><xsl:value-of select="MSI/LAYOUT/LINK"/></xsl:attribute>
<xsl:attribute name="ALINK"><xsl:value-of select="MSI/LAYOUT/ALINK"/></xsl:attribute>
<xsl:attribute name="VLINK"><xsl:value-of select="MSI/LAYOUT/VLINK"/></xsl:attribute>
<xsl:attribute name="BACKGROUND"><xsl:value-of select="MSI/LAYOUT/BACKGROUND"/></xsl:attribute>

<!-- End of Include section -->



<!-- Page Specific Data -->
<!-- ***************************************************************************************** -->

<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[
function reCalc() {
	
	form = document.POINFO;
   var field = form.ITEMTOTAL;  
   var items = form.elements;
   var length = items.length - 7;
	var sum = 0;
	var comSum = 0;
	var i = 2;
   
		while(i<length)
		{
			
			
			if(items[i].value != '' 
				&& items[i+1].value == '') 
			{
				items[i+1].value = items[i+7].value;	
			}
			
			
			if(items[i+1].value != '' 
				&& items[i].value == '') 
			{
				items[i].value = items[i+6].value;	
			}
			
			
			if(items[i].value != '' 
				&& items[i+1].value != '') 
			{
				items[i+2].value = items[i+1].value * items[i].value;	
			}
		
			if(items[i+2].value == "")
			{
				sum = parseFloat(items[i+4].value) + sum;
				var com = items[i+5].value/100;
				comSum = items[i+4].value * com + comSum; 			
		
			}
			else
			{
				sum = parseFloat(items[i+2].value) + sum;
				comSum = items[i+2].value * items[i+5].value/100 + comSum; 			
			}
			i=i+9;	
   	}
	 	
		form.TOTALAMOUNT.value = '$' + sum*100/100;
		form.TOTALCOM.value = '$' + comSum*100/100;
   }	   
   
]]>
</xsl:comment>
</SCRIPT>




<CENTER><FONT FACE="Times New Roman" SIZE="4"><B>Reconcile PO</B></FONT></CENTER>
<P></P>

<FORM METHOD="POST" NAME="POINFO">


<TABLE BORDER="1">

<TR>
<TD>PO Number</TD>
<TD>Rep</TD>
<TD>Date Ordered</TD>
<TD>Sent by</TD>
<TD>Supplier</TD>
<TD>Customer</TD>
<TD>Order Amount</TD>
</TR>


<TR>
<TD><xsl:value-of select="MSI/POINFO/POInfoTable/poidnum"/></TD>
<TD><xsl:value-of select="MSI/POINFO/POInfoTable/repid"/></TD>
<TD><xsl:value-of select="MSI/POINFO/POInfoTable/dateordered"/></TD>
<TD><xsl:value-of select="MSI/POINFO/POInfoTable/sentby"/></TD>
<TD><xsl:value-of select="MSI/POINFO/POInfoTable/suppliername"/></TD>
<TD><xsl:value-of select="MSI/CUSTOMERINFO/CompanyTable/company_name"/></TD>
<TD>$<xsl:value-of select="MSI/POINFO/POInfoTable/originalprice"/></TD>
</TR>

</TABLE>

<TABLE>
<TR>
<TD>Cancel this order: </TD>
<TD>

<xsl:choose>
<xsl:when test="MSI/POINFO/POInfoTable/datecancelled[.!='']">

<INPUT TYPE="CheckBox" NAME="CANCELLED" VALUE="CANCELLED" CHECKED="yes"></INPUT>
<TD>Cancelled On <xsl:value-of select="MSI/POINFO/POInfoTable/datecancelled"/></TD>
</xsl:when>

<xsl:otherwise>
<INPUT TYPE="CheckBox" NAME="CANCELLED" VALUE="CANCELLED"></INPUT>
</xsl:otherwise>
</xsl:choose>

</TD>
</TR>

<TR>
<TD>Mark this order reconciled:</TD>
<TD>

<xsl:choose>
<xsl:when test="MSI/POINFO/POInfoTable/datereconciled[.!='']">
<INPUT TYPE="CheckBox" NAME="RECONCILED" VALUE="RECONCILED" CHECKED="yes"></INPUT>
<TD>Reconciled On <xsl:value-of select="MSI/POINFO/POInfoTable/datereconciled"/></TD>
</xsl:when>

<xsl:otherwise>
<INPUT TYPE="CheckBox" NAME="RECONCILED" VALUE="RECONCILED"></INPUT>
</xsl:otherwise>
</xsl:choose>

</TD>
</TR>
</TABLE>

<P></P>
<FONT SIZE="4">
<B>Invoice Information:</B>
</FONT>

<TABLE BORDER="1">

<TR>
<TD>Invoice #</TD>
<TD>Date</TD>
<TD>Total Amount</TD>
<TD>Adjustment</TD>
<TD>Shipping</TD>
<TD>Sub Total</TD>
<TD>Notes</TD>
</TR>


<xsl:for-each select="MSI/INVOICEINFO/POInvoiceTable" order-by="i10">
<TR>
<TD><xsl:value-of select="i2"/></TD>
<TD><xsl:value-of select="i10"/></TD>
<TD>$<xsl:value-of select="i3"/></TD>
<TD>$<xsl:value-of select="i4"/></TD>
<TD>$<xsl:value-of select="i5"/></TD>
<TD>$<xsl:value-of select="i6"/></TD>
<TD><xsl:value-of select="i9"/></TD>
</TR>
</xsl:for-each>

</TABLE>


<P></P>
<FONT SIZE="4">
<B>Commission Expected: $<xsl:value-of select="MSI/POINFO/POInfoTable/commissionexpected"/>
</B>
</FONT>


<TABLE BORDER="1">

<TR>
<TD>Check #</TD>
<TD>Date</TD>
<TD>Inv #</TD>
<TD>Amount</TD>
<TD>Rep Info</TD>
<TD>Check #</TD>
<TD>Date</TD>
<TD>Amount</TD>
<TD>Notes</TD>
</TR>


<xsl:for-each select="MSI/COMINFO/POComTable" order-by="i2">
<TR>
<TD><xsl:value-of select="i0"/></TD>
<TD><xsl:value-of select="i2"/></TD>
<TD><xsl:value-of select="i4"/></TD>
<TD>$<xsl:value-of select="i5"/></TD>
<TD></TD>
<TD><xsl:value-of select="i11"/></TD>
<TD><xsl:value-of select="i6"/></TD>
<xsl:choose>
<xsl:when test="i7[.!='']">
<TD>$<xsl:value-of select="i7"/></TD>
</xsl:when>
</xsl:choose>
<TD><xsl:value-of select="i10"/></TD>

</TR>
</xsl:for-each>
<TR>
<TD>
</TD>
<TD>
</TD>
<TD>
Total Received:
</TD>
<TD>
<xsl:eval>formatNumber(Total(this), "$#,##0.00")</xsl:eval>
</TD>
</TR>

</TABLE>

<P></P>
<FONT SIZE="4">
<B>Items Ordered:</B>
</FONT>

<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>

<TABLE BORDER="1">

<TR>
<TD>Sku</TD>
<TD>Desc</TD>
<TD>Price</TD>
<TD>Quan</TD>
<TD>Total</TD>
<TD>Adjust</TD>
<TD>Price</TD>
<TD>Quan</TD>
<TD>Total</TD>
</TR>


<xsl:for-each select="MSI/POITEMS/POItemTable" order-by="sku">
<TR>
<TD><xsl:value-of select="sku"/></TD>
<TD><xsl:value-of select="description"/></TD>
<TD>$<xsl:value-of select="orderprice"/></TD>
<TD><xsl:value-of select="orderquanity"/></TD>
<TD>$<xsl:value-of select="ordertotal"/></TD>
<TD></TD>
<TD>
<INPUT TYPE="Text" SIZE="7" onChange="reCalc();">
<xsl:attribute name="NAME">price<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="actualprice"/></xsl:attribute>
</INPUT>
</TD>

<TD>
<INPUT TYPE="Text" SIZE="7" onChange="reCalc();">
<xsl:attribute name="NAME">quan<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="actualquanity"/></xsl:attribute>
</INPUT>
</TD>

<TD>
<INPUT TYPE="Text" SIZE="7" readonly="yes">
<xsl:attribute name="NAME">total<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="actualtotal"/></xsl:attribute>
</INPUT>
</TD>

<INPUT TYPE="HIDDEN">
<xsl:attribute name="NAME">sku<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="sku"/></xsl:attribute>
</INPUT>

<INPUT TYPE="HIDDEN">
<xsl:attribute name="NAME">oldTotal<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="ordertotal"/></xsl:attribute>
</INPUT>

<INPUT TYPE="HIDDEN">
<xsl:attribute name="NAME">com<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="commission"/></xsl:attribute>
</INPUT>

<INPUT TYPE="HIDDEN">
<xsl:attribute name="NAME">oldPrice<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="orderprice"/></xsl:attribute>
</INPUT>

<INPUT TYPE="HIDDEN">
<xsl:attribute name="NAME">oldQuanity<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="orderquanity"/></xsl:attribute>
</INPUT>


<INPUT TYPE="HIDDEN">
<xsl:attribute name="NAME">desc<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="description"/></xsl:attribute>
</INPUT>

</TR>
</xsl:for-each>

<TR>
</TR>
<TR>
<TD>
</TD>
<TD>
</TD>
<TD>
</TD>
<TD>
</TD>
<TD>
</TD>
<TD>Total Commission</TD>
<TD><INPUT TYPE="TEXT" NAME="TOTALCOM" VALUE="" readonly="yes" SIZE="7"></INPUT></TD>

<TD>Total Order:</TD>
<TD><INPUT TYPE="TEXT" NAME="TOTALAMOUNT" VALUE="" readonly="yes" SIZE="7"></INPUT></TD>
</TR>

</TABLE>

<INPUT TYPE="HIDDEN" NAME="ITEMTOTAL">
<xsl:attribute name="VALUE"><xsl:value-of select="MSI/POITEMS/FOOTER/TOTALCOUNT"/></xsl:attribute>
</INPUT>

<INPUT TYPE="HIDDEN" NAME="PONUMBER">
<xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFO/POInfoTable/poidnum"/></xsl:attribute>
</INPUT>


<INPUT TYPE="HIDDEN" NAME="disValue" VALUE="809"></INPUT>


<INPUT TYPE="SUBMIT" NAME="UPDATE" VALUE="Update PO"></INPUT>
<INPUT TYPE="SUBMIT" NAME="CANCEL" VALUE="Cancel Changes"></INPUT>
</FORM>

</BODY></HTML>
</xsl:template>





<xsl:script>
<![CDATA[ 
    function Total(invoice)
    {
      items = invoice.selectNodes("/MSI/COMINFO/POComTable");
      var sum2 = 0;
      
      var item = items.nextNode();		
      while (item)
      {
        var price = item.selectSingleNode("i5").nodeTypedValue;
        sum2 += price*1;
	item = items.nextNode();
      }
      
      return sum2;
    }

   ]]> 
 
</xsl:script> 

</xsl:stylesheet>
