/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.context;

import java.io.File;
import java.io.IOException;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.task.Expand;

public class AutoSetup
extends BaseInterceptor {
    int debug = 0;

    public void engineInit(ContextManager cm) throws TomcatException {
        String home = cm.getHome();
        File webappD = new File(String.valueOf(home) + "/webapps");
        if (!webappD.exists() || !webappD.isDirectory()) {
            System.out.println("No webapps/ directory " + webappD);
            return;
        }
        String[] list = webappD.list();
        if (list.length == 0) {
            System.out.println("No apps in webapps/ ");
        }
        int i = 0;
        while (i < list.length) {
            String path;
            String name = list[i];
            if (name.endsWith(".war")) {
                String fname = name.substring(0, name.length() - 4);
                File appDir = new File(String.valueOf(home) + "/webapps/" + fname);
                if (!appDir.exists()) {
                    appDir.mkdirs();
                    Expand expand = new Expand();
                    expand.setSrc(String.valueOf(home) + "/webapps/" + name);
                    expand.setDest(String.valueOf(home) + "/webapps/" + fname);
                    try {
                        expand.execute();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                name = fname;
            }
            if ((path = "/" + name).equals("/ROOT")) {
                path = "";
            }
            if (cm.getContext(path) == null) {
                Context ctx = new Context();
                ctx.setContextManager(cm);
                ctx.setPath(path);
                File f = new File(webappD, name);
                ctx.setDocBase(f.getAbsolutePath());
                ctx.log("Automatic context load docBase=\"" + ctx.getDocBase() + "\"");
                cm.addContext(ctx);
            }
            ++i;
        }
    }

    public void setDebug(int i) {
        this.debug = i;
    }
}

