/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpUtils;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.HttpServletRequestFacade;
import org.apache.tomcat.core.HttpServletResponseFacade;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.util.StringManager;

public class RequestDispatcherImpl
implements RequestDispatcher {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    Context context;
    String path;
    String queryString;
    String name;

    RequestDispatcherImpl(Context context) {
        this.context = context;
    }

    void addQueryString(Request req, String inQueryString) {
        if (inQueryString == null || inQueryString.trim().length() <= 0) {
            return;
        }
        Hashtable newParams = HttpUtils.parseQueryString((String)this.queryString);
        Hashtable parameters = req.getParameters();
        Enumeration e = newParams.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object oldValue = parameters.get(key);
            Object newValue = newParams.get(key);
            if (oldValue == null) {
                parameters.put(key, newValue);
                continue;
            }
            String[] oldValues = null;
            oldValues = oldValue instanceof String[] ? (String[])oldValue : (oldValue instanceof String ? new String[]{(String)oldValue} : new String[]{oldValue.toString()});
            String[] newValues = null;
            newValues = newValue instanceof String[] ? (String[])newValue : (newValue instanceof String ? new String[]{(String)newValue} : new String[]{newValue.toString()});
            String[] mergedValues = new String[newValues.length + oldValues.length];
            int i = 0;
            while (i < newValues.length) {
                mergedValues[i] = newValues[i];
                ++i;
            }
            int i2 = newValues.length;
            while (i2 < mergedValues.length) {
                mergedValues[i2] = oldValues[i2 - newValues.length];
                ++i2;
            }
            parameters.put(key, mergedValues);
        }
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Request realRequest = ((HttpServletRequestFacade)request).getRealRequest();
        Response realResponse = ((HttpServletResponseFacade)response).getRealResponse();
        if (realResponse.isBufferCommitted()) {
            throw new IllegalStateException(this.sm.getString("rdi.forward.ise"));
        }
        if (this.name != null) {
            this.forwardNamed(request, response);
            return;
        }
        realRequest.setContext(this.context);
        realRequest.setLookupPath(this.path);
        realRequest.setRequestURI(String.valueOf(this.context.getPath()) + this.path);
        if (this.queryString != null) {
            this.addQueryString(realRequest, this.queryString);
        }
        this.context.getContextManager().processRequest(realRequest);
        realRequest.getWrapper().handleRequest(realRequest, realResponse);
    }

    public void forwardNamed(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ServletWrapper wrapper = this.context.getServletByName(this.name);
        wrapper.handleRequest((HttpServletRequestFacade)request, (HttpServletResponseFacade)response);
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Request realRequest = ((HttpServletRequestFacade)request).getRealRequest();
        Response realResponse = ((HttpServletResponseFacade)response).getRealResponse();
        if (this.name != null) {
            this.includeNamed(request, response);
            return;
        }
        boolean old_included = realResponse.isIncluded();
        if (!old_included) {
            realResponse.setIncluded(true);
        }
        Request subRequest = this.context.getContextManager().createRequest(this.context, this.path);
        subRequest.setResponse(realResponse);
        this.context.getContextManager().processRequest(subRequest);
        Object old_request_uri = realRequest.getAttribute("javax.servlet.include.request_uri");
        realRequest.setAttribute("javax.servlet.include.request_uri", this.path);
        Object old_context_path = realRequest.getAttribute("javax.servlet.include.context_path");
        realRequest.setAttribute("javax.servlet.include.context_path", this.context.getPath());
        Object old_servlet_path = realRequest.getAttribute("javax.servlet.include.servlet_path");
        realRequest.setAttribute("javax.servlet.include.servlet_path", subRequest.getServletPath());
        Object old_path_info = realRequest.getAttribute("javax.servlet.include.path_info");
        realRequest.setAttribute("javax.servlet.include.path_info", subRequest.getPathInfo());
        Object old_query_string = realRequest.getAttribute("javax.servlet.include.query_string");
        realRequest.setAttribute("javax.servlet.include.query_string", this.queryString);
        realRequest.getParameterNames();
        Hashtable old_parameters = (Hashtable)realRequest.getParameters().clone();
        this.addQueryString(realRequest, this.queryString);
        subRequest.getWrapper().handleRequest(realRequest, realResponse);
        realRequest.setParameters(old_parameters);
        this.replaceAttribute(realRequest, "javax.servlet.include.request_uri", old_request_uri);
        this.replaceAttribute(realRequest, "javax.servlet.include.context_path", old_context_path);
        this.replaceAttribute(realRequest, "javax.servlet.include.servlet_path", old_servlet_path);
        this.replaceAttribute(realRequest, "javax.servlet.include.path_info", old_path_info);
        this.replaceAttribute(realRequest, "javax.servlet.include.query_string", old_query_string);
        if (!old_included) {
            realResponse.setIncluded(false);
        }
    }

    public void includeNamed(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ServletWrapper wrapper = this.context.getServletByName(this.name);
        wrapper.handleRequest((HttpServletRequestFacade)request, (HttpServletResponseFacade)response);
    }

    private void replaceAttribute(Request realRequest, String name, Object value) {
        if (value == null) {
            realRequest.removeAttribute(name);
        } else {
            realRequest.setAttribute(name, value);
        }
    }

    void setName(String name) {
        this.name = name;
    }

    void setPath(String urlPath) {
        int i = urlPath.indexOf("?");
        if (i < 0) {
            this.path = urlPath;
        } else {
            this.path = urlPath.substring(0, i);
            int len = urlPath.length();
            if (i < len) {
                this.queryString = urlPath.substring(i + 1);
            }
        }
    }
}

