/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import org.apache.tomcat.core.BufferedServletOutputStream;
import org.apache.tomcat.core.HttpServletResponseFacade;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.util.LocaleToCharsetMap;
import org.apache.tomcat.util.MimeHeaders;
import org.apache.tomcat.util.RequestUtil;
import org.apache.tomcat.util.StringManager;

public class ResponseImpl
implements Response {
    protected static StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    protected Request request;
    protected HttpServletResponseFacade responseFacade;
    protected Vector userCookies = new Vector();
    protected String contentType = "text/plain";
    protected String contentLanguage = null;
    protected String characterEncoding = "8859_1";
    protected String sessionId;
    protected int contentLength = -1;
    protected int status = 200;
    private Locale locale = new Locale("en", "");
    protected MimeHeaders headers = new MimeHeaders();
    protected BufferedServletOutputStream out;
    protected PrintWriter writer;
    protected boolean usingStream = false;
    protected boolean usingWriter = false;
    protected boolean started = false;
    protected boolean committed = false;
    boolean notIncluded = true;
    StringBuffer body = new StringBuffer();

    public ResponseImpl() {
        this.responseFacade = new HttpServletResponseFacade(this);
        this.out = new BufferedServletOutputStream();
        this.out.setResponse(this);
    }

    public void addCookie(Cookie cookie) {
        if (this.notIncluded) {
            this.userCookies.addElement(cookie);
        }
    }

    public void addHeader(String name, String value) {
        if (!this.notIncluded) {
            return;
        }
        if (!this.checkSpecialHeader(name, value)) {
            this.headers.addHeader(name, value);
        }
    }

    private boolean checkSpecialHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            this.setContentType(value);
            return true;
        }
        if (name.equalsIgnoreCase("Content-Length")) {
            try {
                int cL = Integer.parseInt(value);
                this.setContentLength(cL);
                return true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        name.equalsIgnoreCase("Content-Language");
        return false;
    }

    private static String constructLocalizedContentType(String type, Locale loc) {
        String charset;
        int semi = type.indexOf(";");
        if (semi != -1) {
            type = type.substring(0, semi);
        }
        if ((charset = LocaleToCharsetMap.getCharset(loc)) != null) {
            type = String.valueOf(type) + "; charset=" + charset;
        }
        return type;
    }

    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    public void doWrite(byte[] buffer, int pos, int count) throws IOException {
        this.body.append(new String(buffer, pos, count, "8859_1"));
    }

    public void endHeaders() throws IOException {
        if (this.request.getProtocol() == null) {
            return;
        }
        if (this.request.getContext() != null && this.notIncluded) {
            this.request.getContext().getContextManager().doBeforeBody(this.request, this);
        }
    }

    public void finish() throws IOException {
        try {
            if (this.usingWriter && this.writer != null) {
                this.writer.flush();
                this.writer.close();
            }
            this.out.reallyFlush();
            this.request.getContextManager().doAfterBody(this.request, this);
            this.out.close();
        }
        catch (SocketException socketException) {
            if (this.request != null) {
                this.request.getContext().log("Socket Exception" + this.request.getRequestURI());
            }
            return;
        }
        catch (IOException ex) {
            if ("Broken pipe".equals(ex.getMessage())) {
                if (this.request != null) {
                    this.request.getContext().log("Broken pipe " + this.request.getRequestURI());
                }
                return;
            }
            throw ex;
        }
    }

    public void flushBuffer() throws IOException {
        if (this.usingWriter && this.writer != null) {
            this.writer.flush();
        }
        this.out.reallyFlush();
    }

    public StringBuffer getBody() {
        return this.body;
    }

    public int getBufferSize() {
        return this.out.getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Enumeration getCookies() {
        return this.userCookies.elements();
    }

    public HttpServletResponseFacade getFacade() {
        return this.responseFacade;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static String getMessage(int status) {
        return sm.getString("sc." + status);
    }

    public ServletOutputStream getOutputStream() {
        this.started = true;
        if (this.usingWriter) {
            String msg = sm.getString("serverResponse.outputStream.ise");
            throw new IllegalStateException(msg);
        }
        this.usingStream = true;
        return this.out;
    }

    public Request getRequest() {
        return this.request;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getStatus() {
        return this.status;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.usingStream) {
            String msg = sm.getString("serverResponse.writer.ise");
            throw new IllegalStateException(msg);
        }
        this.started = true;
        this.usingWriter = true;
        String encoding = this.getCharacterEncoding();
        if (encoding == null || "Default".equals(encoding)) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.out)));
        } else {
            try {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.out), encoding));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.out)));
                System.out.println("Unsuported encoding: " + encoding);
            }
        }
        this.out.setUsingWriter(true);
        return this.writer;
    }

    public boolean isBufferCommitted() {
        return this.out.isCommitted();
    }

    public boolean isIncluded() {
        return this.notIncluded ^ true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isUsingStream() {
        return this.usingStream;
    }

    public void recycle() {
        this.userCookies.removeAllElements();
        this.contentType = "text/plain";
        this.locale = new Locale("en", "");
        this.characterEncoding = "8859_1";
        this.contentLength = -1;
        this.status = 200;
        this.headers.clear();
        this.usingWriter = false;
        this.usingStream = false;
        this.sessionId = null;
        this.writer = null;
        this.out.recycle();
        this.started = false;
        this.committed = false;
        this.notIncluded = true;
        this.status = -1;
        this.body.setLength(0);
    }

    public void reset() throws IllegalStateException {
        this.userCookies.removeAllElements();
        this.contentType = "text/plain";
        this.locale = new Locale("en", "");
        this.characterEncoding = "8859_1";
        this.contentLength = -1;
        this.status = 200;
        if (this.usingWriter && this.writer != null) {
            this.writer.flush();
        }
        this.out.reset();
        if (this.notIncluded) {
            this.headers.clear();
        }
    }

    public void setBufferSize(int size) throws IllegalStateException {
        if (this.usingWriter && this.writer != null) {
            this.writer.flush();
        }
        if (this.out.isContentWritten()) {
            String msg = sm.getString("servletOutputStreamImpl.setbuffer.ise");
            throw new IllegalStateException(msg);
        }
        this.out.setBufferSize(size);
    }

    public void setContentLength(int contentLength) {
        if (!this.notIncluded) {
            return;
        }
        this.contentLength = contentLength;
        this.headers.putHeader("Content-Length", new Integer(contentLength).toString());
    }

    public void setContentType(String contentType) {
        if (!this.notIncluded) {
            return;
        }
        this.contentType = contentType;
        String encoding = RequestUtil.getCharsetFromContentType(contentType);
        if (encoding != null) {
            this.characterEncoding = encoding;
        }
        this.headers.putHeader("Content-Type", contentType);
    }

    public void setHeader(String name, String value) {
        if (!this.notIncluded) {
            return;
        }
        if (!this.checkSpecialHeader(name, value)) {
            this.headers.putHeader(name, value);
        }
    }

    public void setIncluded(boolean incl) {
        this.notIncluded = incl ^ true;
    }

    public void setLocale(Locale locale) {
        if (locale == null || !this.notIncluded) {
            return;
        }
        this.locale = locale;
        this.contentLanguage = locale.getLanguage();
        String newType = ResponseImpl.constructLocalizedContentType(this.contentType, locale);
        this.setContentType(newType);
        this.headers.putHeader("Content-Language", this.contentLanguage);
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setSessionId(String id) {
        if (this.notIncluded) {
            this.sessionId = id;
        }
    }

    public void setStatus(int status) {
        if (!this.notIncluded) {
            return;
        }
        this.status = status;
    }
}

