/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextInterceptor;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.HttpServletRequestFacade;
import org.apache.tomcat.core.HttpServletResponseFacade;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.RequestInterceptor;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletConfigImpl;
import org.apache.tomcat.core.ServletLoader;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.StringManager;

public class ServletWrapper {
    protected StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    protected Context context;
    protected ContextManager contextM;
    protected String servletClassName;
    protected ServletConfigImpl config;
    protected Servlet servlet;
    protected Class servletClass;
    private String path = null;
    protected String description = null;
    boolean initialized = false;
    Exception unavailable = null;
    long unavailableTime = -1L;
    protected boolean isReloadable = false;
    protected long lastAccessed;
    protected int serviceCount = 0;
    int loadOnStartup = 0;
    Hashtable initArgs = null;
    Hashtable securityRoleRefs = new Hashtable();
    static boolean haveContextClassLoader = true;
    static Class[] noParams = new Class[0];
    static Class[] clParam = new Class[1];
    static Object[] noObjs = new Object[0];
    static /* synthetic */ Class class$java$lang$ClassLoader;

    static {
        ServletWrapper.clParam[0] = class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = ServletWrapper.class$("java.lang.ClassLoader"));
    }

    public ServletWrapper() {
        this.config = new ServletConfigImpl();
    }

    ServletWrapper(Context context) {
        this.config = new ServletConfigImpl();
        this.setContext(context);
    }

    public void addInitParam(String name, String value) {
        if (this.initArgs == null) {
            this.initArgs = new Hashtable();
            this.config.setInitArgs(this.initArgs);
        }
        this.initArgs.put(name, value);
    }

    public void addSecurityMapping(String name, String role, String description) {
        this.securityRoleRefs.put(name, role);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    void destroy() {
        this.initialized = false;
        if (this.servlet != null) {
            ServletWrapper servletWrapper = this;
            synchronized (servletWrapper) {
                while (this.serviceCount > 0) {
                    try {
                        this.wait(30000L);
                        break;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    ContextInterceptor[] cI = this.context.getContextInterceptors();
                    int i = 0;
                    while (i < cI.length) {
                        try {
                            cI[i].preServletDestroy(this.context, this);
                        }
                        catch (TomcatException ex) {
                            this.context.log("Error in preServletDestroy " + cI, ex);
                        }
                        ++i;
                    }
                    this.servlet.destroy();
                    int i2 = cI.length - 1;
                    while (i2 >= 0) {
                        try {
                            cI[i2].postServletDestroy(this.context, this);
                        }
                        catch (TomcatException ex) {
                            this.context.log("Error in postServletDestroy " + cI, ex);
                        }
                        --i2;
                    }
                }
                catch (Exception ex) {
                    this.context.log("Error in destroy ", ex);
                }
            }
        }
    }

    ClassLoader fixJDKContextClassLoader(ClassLoader cl) {
        if (cl == null) {
            return null;
        }
        if (!haveContextClassLoader) {
            return null;
        }
        Thread t = Thread.currentThread();
        try {
            Method getCCL = t.getClass().getMethod("getContextClassLoader", noParams);
            Method setCCL = t.getClass().getMethod("setContextClassLoader", clParam);
            if (getCCL == null || setCCL == null) {
                haveContextClassLoader = false;
                return null;
            }
            ClassLoader old = (ClassLoader)getCCL.invoke((Object)t, noObjs);
            Object[] params = new Object[]{cl};
            setCCL.invoke((Object)t, params);
            return old;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            haveContextClassLoader = false;
        }
        catch (Exception ex) {
            haveContextClassLoader = false;
            this.context.log("Error setting jdk context class loader", ex);
        }
        return null;
    }

    protected Context getContext() {
        return this.context;
    }

    public int getLoadOnStartUp() {
        return this.loadOnStartup;
    }

    public String getPath() {
        return this.path;
    }

    public String getSecurityRole(String name) {
        return (String)this.securityRoleRefs.get(name);
    }

    public Servlet getServlet() {
        block2: {
            if (this.servlet != null) break block2;
            try {
                this.loadServlet();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.servlet;
    }

    public String getServletClass() {
        return this.servletClassName;
    }

    public String getServletDescription() {
        return this.description;
    }

    public String getServletName() {
        return this.config.getServletName();
    }

    void handleReload() {
        ServletLoader loader;
        if (this.isReloadable && !"invoker".equals(this.getServletName()) && (loader = this.context.getServletLoader()) != null && loader.shouldReload()) {
            this.destroy();
            this.initialized = false;
            loader.reload();
            this.servlet = null;
            this.servletClass = null;
        }
    }

    public void handleRequest(HttpServletRequestFacade request, HttpServletResponseFacade response) {
        Request rrequest = request.getRealRequest();
        Response rresponse = rrequest.getResponse();
        this.handleRequest(rrequest, rresponse);
    }

    public void handleRequest(Request req, Response res) {
        ClassLoader originalCL = null;
        try {
            if (this.path != null) {
                String requestURI = String.valueOf(this.path) + req.getPathInfo();
                RequestDispatcher rd = req.getContext().getRequestDispatcher(requestURI);
                if (!res.isStarted()) {
                    rd.forward((ServletRequest)req.getFacade(), (ServletResponse)res.getFacade());
                } else {
                    rd.include((ServletRequest)req.getFacade(), (ServletResponse)res.getFacade());
                }
                return;
            }
        }
        catch (Throwable ex) {
            if (req.getAttribute("tomcat.servlet.error.defaultHandler") != null) {
                this.context.log("ERROR: can't find default error handler or error in default error page", ex);
                ex.printStackTrace();
            } else {
                this.contextM.handleError(req, res, ex, 0);
            }
            return;
        }
        this.handleReload();
        if (!this.initialized) {
            if (this.unavailable != null) {
                long moreWaitTime = this.unavailableTime - System.currentTimeMillis();
                if (this.unavailableTime > 0L && moreWaitTime < 0L) {
                    this.unavailable = null;
                    this.unavailableTime = -1L;
                    this.context.log(String.valueOf(this.getServletName()) + " unavailable time expired, try again ");
                } else {
                    if (this.unavailableTime > 0L) {
                        res.setHeader("Retry-After", Long.toString(moreWaitTime / 1000L));
                    }
                    String msg = this.unavailable.getMessage();
                    this.context.log("Error in " + this.getServletName() + "init(), error happened at " + this.unavailableTime + " wait " + moreWaitTime + " : " + msg, this.unavailable);
                    req.setAttribute("javax.servlet.error.message", msg);
                    res.setStatus(503);
                    this.contextM.handleError(req, res, null, 503);
                    return;
                }
            }
            try {
                this.initServlet();
            }
            catch (ClassNotFoundException ex) {
                this.context.log("Class Not Found in init", ex);
                res.setStatus(404);
                this.contextM.handleError(req, res, null, 404);
                return;
            }
            catch (Exception ex) {
                this.context.log("Exception in init servlet " + ex.getMessage(), ex);
            }
        }
        if (this.unavailable != null) {
            int secs;
            res.setStatus(503);
            if (this.unavailable instanceof UnavailableException && (secs = ((UnavailableException)this.unavailable).getUnavailableSeconds()) > 0) {
                res.setHeader("Retry-After", Integer.toString(secs));
            }
            String msg = this.unavailable.getMessage();
            this.context.log("Error in " + this.getServletName() + " init(): " + msg, this.unavailable);
            req.setAttribute("javax.servlet.error.message", msg);
            this.contextM.handleError(req, res, null, 503);
            return;
        }
        if (this.servlet == null) {
            this.context.log("Can't find servet " + this.getServletName());
            res.setStatus(404);
            this.contextM.handleError(req, res, null, 404);
            return;
        }
        try {
            try {
                originalCL = this.fixJDKContextClassLoader(this.context.getServletLoader().getClassLoader());
                RequestInterceptor[] cI = this.context.getRequestInterceptors();
                int i = 0;
                while (i < cI.length) {
                    cI[i].preService(req, res);
                    ++i;
                }
                if (this.servlet instanceof SingleThreadModel) {
                    Servlet servlet = this.servlet;
                    synchronized (servlet) {
                        this.servlet.service((ServletRequest)req.getFacade(), (ServletResponse)res.getFacade());
                    }
                } else {
                    this.servlet.service((ServletRequest)req.getFacade(), (ServletResponse)res.getFacade());
                }
                int i2 = cI.length - 1;
                while (i2 >= 0) {
                    cI[i2].postService(req, res);
                    --i2;
                }
            }
            catch (Throwable t) {
                if (req.getAttribute("tomcat.servlet.error.defaultHandler") != null) {
                    System.out.println("ERROR: can't find default error handler or error in default error page");
                    t.printStackTrace();
                }
                String msg = t.getMessage();
                this.context.log("Error in " + this.getServletName() + " service() : " + msg, t);
                this.contextM.handleError(req, res, t, 0);
            }
            Object var5_13 = null;
            this.fixJDKContextClassLoader(originalCL);
        }
        catch (Throwable throwable) {
            Object var5_14 = null;
            this.fixJDKContextClassLoader(originalCL);
            throw throwable;
        }
    }

    void initServlet() throws ClassNotFoundException, InstantiationException, IllegalAccessException, ServletException {
        ClassLoader originalCL = null;
        originalCL = this.fixJDKContextClassLoader(this.context.getServletLoader().getClassLoader());
        try {
            if (this.servletClass == null) {
                if (this.servletClassName == null) {
                    throw new IllegalStateException(this.sm.getString("wrapper.load.noclassname"));
                }
                this.servletClass = this.context.getServletLoader().loadClass(this.servletClassName);
            }
            if (this.servletClass == null) {
                throw new ServletException("Error loading servlet " + this.servletClassName);
            }
            this.servlet = (Servlet)this.servletClass.newInstance();
            if (this.servlet == null) {
                throw new ServletException("Error insantiating servlet " + this.servletClassName);
            }
            this.config.setServletClassName(this.servlet.getClass().getName());
            try {
                Servlet sinstance = this.servlet;
                ServletConfigImpl servletConfig = this.config;
                ContextInterceptor[] cI = this.context.getContextInterceptors();
                int i = 0;
                while (i < cI.length) {
                    try {
                        cI[i].preServletInit(this.context, this);
                    }
                    catch (TomcatException ex) {
                        ex.printStackTrace();
                    }
                    ++i;
                }
                this.servlet.init((ServletConfig)servletConfig);
                int i2 = cI.length - 1;
                while (i2 >= 0) {
                    try {
                        cI[i2].postServletInit(this.context, this);
                    }
                    catch (TomcatException ex) {
                        ex.printStackTrace();
                    }
                    --i2;
                }
                this.initialized = true;
                this.unavailable = null;
            }
            catch (UnavailableException ex) {
                this.unavailable = ex;
                this.unavailableTime = System.currentTimeMillis();
                this.unavailableTime += (long)(ex.getUnavailableSeconds() * 1000);
            }
            catch (Exception ex) {
                this.unavailable = ex;
            }
            Object var3_11 = null;
            this.fixJDKContextClassLoader(originalCL);
        }
        catch (Throwable throwable) {
            Object var3_12 = null;
            this.fixJDKContextClassLoader(originalCL);
            throw throwable;
        }
    }

    public void loadServlet() throws ClassNotFoundException, InstantiationException, IllegalAccessException, ServletException {
        this.initServlet();
    }

    public void setContext(Context context) {
        this.context = context;
        this.contextM = context.getContextManager();
        this.config.setContext(context);
        this.isReloadable = context.getReloadable();
    }

    public void setLoadOnStartUp(int level) {
        this.loadOnStartup = level;
    }

    public void setLoadOnStartUp(String level) {
        this.loadOnStartup = new Integer(level);
    }

    public void setPath(String path) {
        this.path = path;
    }

    void setReloadable(boolean reloadable) {
        this.isReloadable = reloadable;
    }

    public void setServletClass(String servletClassName) {
        this.servletClassName = servletClassName;
        this.config.setServletClassName(servletClassName);
    }

    public void setServletDescription(String description) {
        this.description = description;
    }

    public void setServletName(String servletName) {
        this.config.setServletName(servletName);
    }

    public String toString() {
        String toS = "Wrapper(" + this.config.getServletName() + " ";
        toS = this.servlet != null ? String.valueOf(toS) + "S:" + this.servlet.getClass().getName() : String.valueOf(toS) + this.servletClassName;
        return String.valueOf(toS) + ")";
    }
}

