/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.session;

import org.apache.tomcat.catalina.Lifecycle;
import org.apache.tomcat.catalina.LifecycleException;
import org.apache.tomcat.catalina.Session;
import org.apache.tomcat.session.ManagerBase;
import org.apache.tomcat.session.StandardSession;
import org.apache.tomcat.util.StringManager;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class StandardManager
extends ManagerBase
implements Lifecycle,
Runnable {
    private int checkInterval = 60;
    private boolean configured = false;
    private static final String info = "StandardManager/1.0";
    protected int maxActiveSessions = -1;
    private StringManager sm = StringManager.getManager("org.apache.tomcat.session");
    private boolean started = false;
    private Thread thread = null;
    private boolean threadDone = false;
    private String threadName = "StandardManager";

    public void configure(Node parameters) throws LifecycleException {
        block11: {
            if (this.configured) {
                throw new LifecycleException(this.sm.getString("standardManager.alreadyConfigured"));
            }
            this.configured = true;
            if (parameters == null) {
                return;
            }
            if (!"Manager".equals(parameters.getNodeName())) {
                return;
            }
            NamedNodeMap attributes = parameters.getAttributes();
            Node node = null;
            node = attributes.getNamedItem("checkInterval");
            if (node != null) {
                try {
                    this.setCheckInterval(Integer.parseInt(node.getNodeValue()));
                }
                catch (Throwable throwable) {}
            }
            if ((node = attributes.getNamedItem("maxActiveSessions")) != null) {
                try {
                    this.setMaxActiveSessions(Integer.parseInt(node.getNodeValue()));
                }
                catch (Throwable throwable) {}
            }
            if ((node = attributes.getNamedItem("maxInactiveInterval")) == null) break block11;
            try {
                this.setMaxInactiveInterval(Integer.parseInt(node.getNodeValue()));
            }
            catch (Throwable throwable) {}
        }
    }

    public Session createSession() {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            throw new IllegalStateException(this.sm.getString("standardManager.createSession.ise"));
        }
        return super.createSession();
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public String getInfo() {
        return info;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    private void processExpires() {
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        int i = 0;
        while (i < sessions.length) {
            int timeIdle;
            int maxInactiveInterval;
            StandardSession session = (StandardSession)sessions[i];
            if (session.isValid() && (maxInactiveInterval = session.getMaxInactiveInterval()) >= 0 && (timeIdle = (int)((timeNow - session.getLastAccessedTime()) / 1000L)) >= maxInactiveInterval) {
                session.expire();
            }
            ++i;
        }
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
        }
    }

    public void setCheckInterval(int checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void setMaxActiveSessions(int max) {
        this.maxActiveSessions = max;
    }

    public void start() throws LifecycleException {
        if (!this.configured) {
            throw new LifecycleException(this.sm.getString("standardManager.notConfigured"));
        }
        if (this.started) {
            throw new LifecycleException(this.sm.getString("standardManager.alreadyStarted"));
        }
        this.started = true;
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("standardManager.notStarted"));
        }
        this.started = false;
        this.threadStop();
        Session[] sessions = this.findSessions();
        int i = 0;
        while (i < sessions.length) {
            StandardSession session = (StandardSession)sessions[i];
            if (session.isValid()) {
                session.expire();
            }
            ++i;
        }
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.thread = null;
    }
}

