/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.servlet.http.Cookie;
import org.apache.tomcat.util.HttpDate;

public class CookieUtils {
    private static final String tspecials = "()<>@,;:\\\"/[]?={} \t";

    public static String getCookieHeader(Cookie cookie) {
        StringBuffer buf = new StringBuffer();
        int version = cookie.getVersion();
        buf.append(cookie.getName());
        buf.append("=");
        CookieUtils.maybeQuote(version, buf, cookie.getValue());
        if (version == 1) {
            buf.append(";Version=1");
            if (cookie.getComment() != null) {
                buf.append(";Comment=");
                CookieUtils.maybeQuote(version, buf, cookie.getComment());
            }
        }
        if (cookie.getDomain() != null) {
            buf.append(";Domain=");
            CookieUtils.maybeQuote(version, buf, cookie.getDomain());
        }
        if (cookie.getMaxAge() >= 0) {
            if (version == 0) {
                buf.append(";Expires=");
                new OldCookieExpiry(cookie.getMaxAge()).append(buf);
            } else {
                buf.append(";MaxAge=");
                buf.append(cookie.getMaxAge());
            }
        } else if (version == 1) {
            buf.append(";Discard");
        }
        if (cookie.getPath() != null) {
            buf.append(";Path=");
            CookieUtils.maybeQuote(version, buf, cookie.getPath());
        }
        if (cookie.getSecure()) {
            buf.append(";Secure");
        }
        if (version == 1) {
            Cookie c = (Cookie)cookie.clone();
            c.setVersion(0);
            StringBuffer buf2 = new StringBuffer("Set-Cookie2: ");
            buf2.append(String.valueOf(String.valueOf(buf)) + "\r\n");
            buf2.append(CookieUtils.getCookieHeader(c));
            return buf2.toString();
        }
        return "Set-Cookie: " + buf.toString();
    }

    private static boolean isToken(String value) {
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c < ' ' || c >= '\u007f' || tspecials.indexOf(c) != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void maybeQuote(int version, StringBuffer buf, String value) {
        if (version == 0 || CookieUtils.isToken(value)) {
            buf.append(value);
        } else {
            buf.append('\"');
            buf.append(value);
            buf.append('\"');
        }
    }

    static class OldCookieExpiry
    extends HttpDate {
        OldCookieExpiry(long maxAge) {
            this.setTime(HttpDate.getCurrentTime() + maxAge * 1000L);
        }

        void append(StringBuffer buf) {
            String pattern = "EEE, dd-MMM-yyyyy HH:mm:ss z";
            Locale loc = Locale.US;
            SimpleDateFormat df = new SimpleDateFormat(pattern, loc);
            String str = df.format(this.calendar.getTime());
            buf.append(str);
        }
    }
}

