/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.xml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.util.Stack;
import org.apache.tomcat.util.xml.AddChild;
import org.apache.tomcat.util.xml.MethodParam;
import org.apache.tomcat.util.xml.MethodSetter;
import org.apache.tomcat.util.xml.ObjectCreate;
import org.apache.tomcat.util.xml.PathMatch;
import org.apache.tomcat.util.xml.SaxContext;
import org.apache.tomcat.util.xml.SetParent;
import org.apache.tomcat.util.xml.SetProperties;
import org.apache.tomcat.util.xml.XmlAction;
import org.apache.tomcat.util.xml.XmlMatch;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserFactory;

public class XmlMapper
implements DocumentHandler,
SaxContext,
EntityResolver,
DTDHandler {
    Locator locator;
    Stack oStack = new Stack();
    Object root;
    Object[] attributeStack;
    String[] tagStack;
    int oSp;
    int sp;
    String body;
    int debug = 0;
    Rule[] rules = new Rule[100];
    Rule[] matching = new Rule[100];
    int ruleCount = 0;

    public XmlMapper() {
        this.attributeStack = new Object[100];
        this.tagStack = new String[100];
        this.initDefaultRules();
    }

    public XmlAction addChild(String parentM, String argType) {
        return new AddChild(parentM, argType);
    }

    public void addRule(String path, XmlAction action) {
        this.rules[this.ruleCount] = new Rule(new PathMatch(path), action);
        ++this.ruleCount;
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.body = String.valueOf(this.body) + new String(buf, offset, len);
    }

    public void endDocument() throws SAXException {
        if (this.sp != 0) {
            System.out.println("The XML document is probably broken. " + this.sp);
        }
    }

    public void endElement(String tag) throws SAXException {
        try {
            this.matchEnd(this);
            if (this.sp > 1) {
                this.tagStack[this.sp] = null;
                this.attributeStack[this.sp] = null;
            }
            --this.sp;
        }
        catch (Exception ex) {
            throw new SAXException(this.positionToString(), ex);
        }
    }

    public AttributeList getAttributeList(int pos) {
        return (AttributeList)this.attributeStack[pos];
    }

    public String getBody() {
        return this.body;
    }

    public int getDebug() {
        return this.debug;
    }

    public Stack getObjectStack() {
        return this.oStack;
    }

    public Object getRoot() {
        return this.root;
    }

    public String getTag(int pos) {
        return this.tagStack[pos];
    }

    public int getTagCount() {
        return this.sp;
    }

    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
    }

    private void initDefaultRules() {
        this.addRule("xmlmapper:debug", new XmlAction(){

            public void start(SaxContext ctx) {
                int top = ctx.getTagCount() - 1;
                AttributeList attributes = ctx.getAttributeList(top);
                String levelS = attributes.getValue("level");
                XmlMapper mapper = (XmlMapper)ctx;
                if (levelS != null) {
                    mapper.setDebug(new Integer(levelS));
                }
            }
        });
        this.addRule("xmlmapper:taskdef", new XmlAction(){

            public void start(SaxContext ctx) {
                block7: {
                    XmlMapper mapper = (XmlMapper)ctx;
                    int top = ctx.getTagCount() - 1;
                    AttributeList attributes = ctx.getAttributeList(top);
                    String match = attributes.getValue("match");
                    if (match == null) {
                        return;
                    }
                    String obj = attributes.getValue("object-create");
                    String objA = attributes.getValue("object-create-attrib");
                    if (obj != null || objA != null) {
                        mapper.addRule(match, new ObjectCreate(obj, objA));
                    }
                    if ((obj = attributes.getValue("set-properties")) != null) {
                        mapper.addRule(match, new SetProperties());
                    }
                    if ((obj = attributes.getValue("set-parent")) != null) {
                        mapper.addRule(match, new SetParent(obj));
                    }
                    obj = attributes.getValue("add-child");
                    objA = attributes.getValue("child-type");
                    if (obj != null) {
                        mapper.addRule(match, new AddChild(obj, objA));
                    }
                    if ((obj = attributes.getValue("action")) == null) break block7;
                    try {
                        Class<?> c = Class.forName(obj);
                        Object o = c.newInstance();
                        mapper.addRule(match, (XmlAction)o);
                    }
                    catch (Exception exception) {
                        System.out.println("Can't add action " + obj);
                    }
                }
            }
        });
    }

    public void log(String msg) {
        System.out.println("XmlMapper: " + msg);
    }

    private int match(SaxContext ctx, Rule[] matching) {
        int matchCount = 0;
        int i = 0;
        while (i < this.ruleCount) {
            if (this.rules[i].match.match(ctx) && this.rules[i].action != null) {
                matching[matchCount] = this.rules[i];
                ++matchCount;
            }
            ++i;
        }
        return matchCount;
    }

    void matchEnd(SaxContext ctx) throws Exception {
        int matchCount = this.match(ctx, this.matching);
        int i = 0;
        while (i < matchCount) {
            this.matching[i].action.end(ctx);
            ++i;
        }
        int i2 = 0;
        while (i2 < matchCount) {
            this.matching[i2].action.cleanup(ctx);
            ++i2;
        }
    }

    void matchStart(SaxContext ctx) throws Exception {
        int matchCount = this.match(ctx, this.matching);
        int i = 0;
        while (i < matchCount) {
            this.matching[i].action.start(ctx);
            ++i;
        }
    }

    public XmlAction methodParam(int ord) {
        return new MethodParam(ord, null);
    }

    public XmlAction methodParam(int ord, String attrib) {
        return new MethodParam(ord, attrib);
    }

    public XmlAction methodSetter(String method, int paramC) {
        return new MethodSetter(method, paramC);
    }

    public XmlAction methodSetter(String method, int paramC, String[] paramTypes) {
        return new MethodSetter(method, paramC, paramTypes);
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        System.out.println("Notation: " + name + " " + publicId + " " + systemId);
    }

    public XmlAction objectCreate(String classN) {
        return new ObjectCreate(classN);
    }

    public XmlAction objectCreate(String classN, String attrib) {
        return new ObjectCreate(classN, attrib);
    }

    private String positionToString() {
        StringBuffer sb = new StringBuffer();
        if (this.locator != null) {
            sb.append("Line ").append(this.locator.getLineNumber()).append(" ");
        }
        sb.append("/");
        int i = 0;
        while (i < this.sp) {
            sb.append(this.tagStack[i]).append("/");
            ++i;
        }
        sb.append(" ");
        AttributeList attributes = (AttributeList)this.attributeStack[this.sp - 1];
        if (attributes != null) {
            int i2 = 0;
            while (i2 < attributes.getLength()) {
                sb.append(attributes.getName(i2)).append("=").append(attributes.getValue(i2));
                sb.append(" ");
                ++i2;
            }
        }
        return sb.toString();
    }

    public void processingInstruction(String name, String instruction) throws SAXException {
    }

    public Object readXml(File xmlFile, Object root) throws Exception {
        if (root != null) {
            Stack st = this.getObjectStack();
            this.root = root;
            st.push(root);
        }
        Parser parser = null;
        try {
            parser = System.getProperty("org.xml.sax.parser") != null ? ParserFactory.makeParser() : ParserFactory.makeParser("com.sun.xml.parser.Parser");
            InputSource input = new InputSource(new FileReader(xmlFile));
            parser.setDocumentHandler(this);
            parser.setEntityResolver(this);
            parser.setDTDHandler(this);
            parser.parse(input);
            return root;
        }
        catch (IllegalAccessException ex1) {
            ex1.printStackTrace();
            throw new Exception("Error creating sax parser");
        }
        catch (ClassNotFoundException ex2) {
            ex2.printStackTrace();
            throw new Exception("Error creating sax parser");
        }
        catch (InstantiationException ex3) {
            ex3.printStackTrace();
            throw new Exception("Error creating sax parser");
        }
        catch (IOException ioe) {
            String msg = "Can't open config file: " + xmlFile + " due to: " + ioe;
            throw new Exception(msg);
        }
        catch (SAXException se) {
            System.out.println("ERROR reading " + xmlFile);
            System.out.println("At " + se.getMessage());
            System.out.println();
            Exception ex1 = se.getException();
            throw ex1;
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (this.debug > 0) {
            this.log("Entity: " + publicId + " " + systemId);
        }
        InputSource is = new InputSource();
        is.setByteStream(new StringBufferInputStream(""));
        return is;
    }

    public void setDebug(int level) {
        if (level != 0) {
            this.log("Debug level: " + level);
        }
        this.debug = level;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.debug > 0) {
            this.log("Set locator : " + locator);
        }
        this.locator = locator;
    }

    public XmlAction setParent(String childM) {
        return new SetParent(childM);
    }

    public XmlAction setProperties() {
        return new SetProperties();
    }

    public void setRoot(Object o) {
        this.root = o;
    }

    public void startDocument() throws SAXException {
        this.sp = 0;
    }

    public void startElement(String tag, AttributeList attributes) throws SAXException {
        try {
            this.attributeStack[this.sp] = attributes;
            this.tagStack[this.sp] = tag;
            ++this.sp;
            this.matchStart(this);
            this.body = "";
        }
        catch (Exception ex) {
            throw new SAXException(this.positionToString(), ex);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        System.out.println("Unparsed: " + name + " " + publicId + " " + systemId + " " + notationName);
    }

    class Rule {
        XmlMatch match;
        XmlAction action;

        Rule(XmlMatch match, XmlAction action) {
            this.match = match;
            this.action = action;
        }
    }
}

