/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Exec;

public class Javadoc
extends Exec {
    private String sourcePath = null;
    private File destDir = null;
    private File overviewFile = null;
    private String sourceFiles = null;
    private String packageNames = null;
    private boolean pub = false;
    private boolean prot = false;
    private boolean pack = false;
    private boolean priv = false;
    private boolean author = true;
    private boolean version = true;
    private String doclet = null;
    private File docletpath = null;
    private boolean old = false;
    private String classpath = null;
    private String bootclasspath = null;
    private String extdirs = null;
    private boolean verbose = false;
    private String locale = null;
    private String encoding = null;
    private boolean use = false;
    private boolean splitindex = false;
    private String windowtitle = null;
    private String doctitle = null;
    private String header = null;
    private String footer = null;
    private String bottom = null;
    private String link = null;
    private String linkoffline = null;
    private String group = null;
    private boolean nodeprecated = false;
    private boolean nodeprecatedlist = false;
    private boolean notree = false;
    private boolean noindex = false;
    private boolean nohelp = false;
    private boolean nonavbar = false;
    private File stylesheetfile = null;
    private File helpfile = null;
    private String docencoding = null;
    private Vector compileList = new Vector(10);

    private void evaluatePackages(String source, Vector packages, Vector argList) {
        this.project.log("Parsing source files for packages", 2);
        this.project.log("Source dir = " + source, 3);
        this.project.log("Packages = " + packages, 3);
        Hashtable map = this.mapClasses(new File(source));
        Enumeration e = map.keys();
        block0: while (e.hasMoreElements()) {
            String pack = (String)e.nextElement();
            int i = 0;
            while (i < packages.size()) {
                if (this.matches(pack, (String)packages.elementAt(i))) {
                    argList.addElement(pack);
                    continue block0;
                }
                ++i;
            }
        }
    }

    public void execute() throws BuildException {
        if (this.sourcePath == null && this.destDir == null) {
            String msg = "sourcePath and destDir attributes must be set!";
            throw new BuildException(msg);
        }
        boolean javadoc1 = Project.getJavaVersion() == "1.1";
        this.project.log("Generating Javadoc", 2);
        Vector<String> argList = new Vector<String>();
        if (this.classpath == null) {
            this.classpath = System.getProperty("java.class.path");
        }
        if (!javadoc1 || this.sourcePath == null) {
            argList.addElement("-classpath");
            argList.addElement(this.classpath);
            if (this.sourcePath != null) {
                argList.addElement("-sourcepath");
                argList.addElement(this.sourcePath);
            }
        } else {
            argList.addElement("-classpath");
            argList.addElement(String.valueOf(this.sourcePath) + System.getProperty("path.separator") + this.classpath);
        }
        if (this.destDir != null) {
            argList.addElement("-d");
            argList.addElement(this.destDir.getAbsolutePath());
        }
        if (this.version) {
            argList.addElement("-version");
        }
        if (this.nodeprecated) {
            argList.addElement("-nodeprecated");
        }
        if (this.author) {
            argList.addElement("-author");
        }
        if (this.noindex) {
            argList.addElement("-noindex");
        }
        if (this.notree) {
            argList.addElement("-notree");
        }
        if (this.pub) {
            argList.addElement("-public");
        }
        if (this.prot) {
            argList.addElement("-protected");
        }
        if (this.pack) {
            argList.addElement("-package");
        }
        if (this.priv) {
            argList.addElement("-private");
        }
        if (this.encoding != null) {
            argList.addElement("-encoding");
            argList.addElement(this.encoding);
        }
        if (this.docencoding != null) {
            argList.addElement("-docencoding");
            argList.addElement(this.docencoding);
        }
        if (!javadoc1) {
            if (this.overviewFile != null) {
                argList.addElement("-overview");
                argList.addElement(this.overviewFile.getAbsolutePath());
            }
            if (this.old) {
                argList.addElement("-1.1");
            }
            if (this.verbose) {
                argList.addElement("-verbose");
            }
            if (this.use) {
                argList.addElement("-use");
            }
            if (this.splitindex) {
                argList.addElement("-splitindex");
            }
            if (this.nodeprecatedlist) {
                argList.addElement("-nodeprecatedlist");
            }
            if (this.nohelp) {
                argList.addElement("-nohelp");
            }
            if (this.nonavbar) {
                argList.addElement("-nonavbar");
            }
            if (this.doclet != null) {
                argList.addElement("-doclet");
                argList.addElement(this.doclet);
            }
            if (this.bootclasspath != null) {
                argList.addElement("-bootclasspath");
                argList.addElement(this.bootclasspath);
            }
            if (this.extdirs != null) {
                argList.addElement("-extdirs");
                argList.addElement(this.extdirs);
            }
            if (this.locale != null) {
                argList.addElement("-locale");
                argList.addElement(this.locale);
            }
            if (this.encoding != null) {
                argList.addElement("-encoding");
                argList.addElement(this.encoding);
            }
            if (this.windowtitle != null) {
                argList.addElement("-windowtitle");
                argList.addElement(this.windowtitle);
            }
            if (this.doctitle != null) {
                argList.addElement("-doctitle");
                argList.addElement(this.doctitle);
            }
            if (this.header != null) {
                argList.addElement("-header");
                argList.addElement(this.header);
            }
            if (this.footer != null) {
                argList.addElement("-footer");
                argList.addElement(this.footer);
            }
            if (this.bottom != null) {
                argList.addElement("-bottom");
                argList.addElement(this.bottom);
            }
            if (this.link != null) {
                argList.addElement("-link");
                argList.addElement(this.link);
            }
            if (this.linkoffline != null) {
                argList.addElement("-linkoffline");
                argList.addElement(this.linkoffline);
            }
            if (this.group != null) {
                argList.addElement("-group");
                argList.addElement(this.group);
            }
            if (this.stylesheetfile != null) {
                argList.addElement("-stylesheetfile");
                argList.addElement(this.stylesheetfile.getAbsolutePath());
            }
            if (this.helpfile != null) {
                argList.addElement("-helpfile");
                argList.addElement(this.helpfile.getAbsolutePath());
            }
        }
        if (this.packageNames != null && this.packageNames.length() > 0) {
            Vector<String> packages = new Vector<String>();
            StringTokenizer tok = new StringTokenizer(this.packageNames, ",", false);
            while (tok.hasMoreTokens()) {
                String name = tok.nextToken().trim();
                if (name.endsWith(".*")) {
                    packages.addElement(name);
                    continue;
                }
                argList.addElement(name);
            }
            if (packages.size() > 0) {
                this.evaluatePackages(this.sourcePath, packages, argList);
            }
        }
        if (this.sourceFiles != null && this.sourceFiles.length() > 0) {
            StringTokenizer tok = new StringTokenizer(this.sourceFiles, ",", false);
            while (tok.hasMoreTokens()) {
                argList.addElement(tok.nextToken().trim());
            }
        }
        this.project.log("Javadoc args: " + argList.toString(), "javadoc", 3);
        this.project.log("Javadoc execution", 2);
        StringBuffer b = new StringBuffer();
        b.append("javadoc ");
        Enumeration e = argList.elements();
        while (e.hasMoreElements()) {
            String arg = (String)e.nextElement();
            if (!arg.startsWith("-")) {
                b.append("\"");
                b.append(arg);
                b.append("\"");
            } else {
                b.append(arg);
            }
            if (!e.hasMoreElements()) continue;
            b.append(" ");
        }
        this.run(b.toString());
    }

    private void getFiles(File path, Vector list) {
        if (!path.exists()) {
            throw new BuildException("Path " + path + " does not exist.");
        }
        String[] files = path.list();
        String cwd = String.valueOf(path.getPath()) + System.getProperty("file.separator");
        if (files != null) {
            int count = 0;
            int i = 0;
            while (i < files.length) {
                File file = new File(String.valueOf(cwd) + files[i]);
                if (file.isDirectory()) {
                    this.getFiles(file, list);
                } else if (files[i].endsWith(".java")) {
                    ++count;
                    list.addElement(file);
                }
                ++i;
            }
            if (count > 0) {
                this.project.log("found " + count + " source files in " + path, "javadoc", 3);
            }
        } else {
            throw new BuildException("Error occurred during " + path + " evaluation.");
        }
    }

    private String getPackageName(File file) {
        String name = null;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new JavaReader(new BufferedReader(new FileReader(file))));
            do {
                if ((line = reader.readLine()) != null) continue;
                this.project.log("Could not evaluate package for " + file, "javadoc", 1);
                return null;
            } while (!line.trim().startsWith("package "));
            name = line.substring(8, line.indexOf(";")).trim();
            reader.close();
        }
        catch (Exception e) {
            this.project.log("Exception " + e + " parsing " + file, "javadoc", 1);
            return null;
        }
        this.project.log(String.valueOf(String.valueOf(file)) + " --> " + name, "javadoc", 3);
        return name;
    }

    private Hashtable mapClasses(File path) {
        Hashtable<String, File> map = new Hashtable<String, File>();
        Vector files = new Vector();
        this.getFiles(path, files);
        Enumeration e = files.elements();
        while (e.hasMoreElements()) {
            File file = (File)e.nextElement();
            String packageName = this.getPackageName(file);
            if (packageName == null) continue;
            map.put(packageName, file);
        }
        return map;
    }

    private boolean matches(String string, String pattern) {
        return string.startsWith(pattern.substring(0, pattern.length() - 2));
    }

    public void setAuthor(String src) {
        this.author = Project.toBoolean(src);
    }

    public void setBootclasspath(String src) {
        this.bootclasspath = this.project.translatePath(src);
    }

    public void setBottom(String src) {
        this.bottom = src;
    }

    public void setClasspath(String src) {
        this.classpath = this.project.translatePath(src);
    }

    public void setDestdir(String src) {
        this.destDir = this.project.resolveFile(src);
    }

    public void setDocencoding(String src) {
        this.docencoding = src;
    }

    public void setDoclet(String src) {
        this.doclet = src;
    }

    public void setDocletPath(String src) {
        this.docletpath = this.project.resolveFile(src);
    }

    public void setDoctitle(String src) {
        this.doctitle = src;
    }

    public void setEncoding(String src) {
        this.encoding = src;
    }

    public void setExtdirs(String src) {
        this.extdirs = src;
    }

    public void setFooter(String src) {
        this.footer = src;
    }

    public void setGroup(String src) {
        this.group = src;
    }

    public void setHeader(String src) {
        this.header = src;
    }

    public void setLink(String src) {
        this.link = src;
    }

    public void setLinkoffline(String src) {
        this.linkoffline = src;
    }

    public void setLocale(String src) {
        this.locale = src;
    }

    public void setNodeprecated(String src) {
        this.nodeprecated = Project.toBoolean(src);
    }

    public void setNodeprecatedlist(String src) {
        this.nodeprecatedlist = Project.toBoolean(src);
    }

    public void setNohelp(String src) {
        this.nohelp = Project.toBoolean(src);
    }

    public void setNoindex(String src) {
        this.noindex = Project.toBoolean(src);
    }

    public void setNonavbar(String src) {
        this.nonavbar = Project.toBoolean(src);
    }

    public void setNotree(String src) {
        this.notree = Project.toBoolean(src);
    }

    public void setOld(String src) {
        this.old = Project.toBoolean(src);
    }

    public void setOverview(String src) {
        this.overviewFile = this.project.resolveFile(src);
    }

    public void setPackage(String src) {
        this.pack = Project.toBoolean(src);
    }

    public void setPackagenames(String src) {
        this.packageNames = src;
    }

    public void setPrivate(String src) {
        this.priv = Project.toBoolean(src);
    }

    public void setProtected(String src) {
        this.prot = Project.toBoolean(src);
    }

    public void setPublic(String src) {
        this.pub = Project.toBoolean(src);
    }

    public void setSourcefiles(String src) {
        this.sourceFiles = src;
    }

    public void setSourcepath(String src) {
        this.sourcePath = this.project.translatePath(src);
    }

    public void setSplitindex(String src) {
        this.splitindex = Project.toBoolean(src);
    }

    public void setStylesheetfile(String src) {
        this.stylesheetfile = this.project.resolveFile(src);
    }

    public void setUse(String src) {
        this.use = Project.toBoolean(src);
    }

    public void setVerbose(String src) {
        this.verbose = Project.toBoolean(src);
    }

    public void setVersion(String src) {
        this.version = Project.toBoolean(src);
    }

    public void setWindowtitle(String src) {
        this.windowtitle = src;
    }

    class JavaReader
    extends FilterReader {
        public JavaReader(Reader in) {
            super(in);
        }

        public int read() throws IOException {
            int c = this.in.read();
            if (c == 47) {
                c = this.in.read();
                if (c == 47) {
                    while (c != 10 && c != -1) {
                        c = this.in.read();
                    }
                } else if (c == 42) {
                    while (c != -1) {
                        c = this.in.read();
                        if (c != 42 || (c = this.in.read()) != 47) continue;
                        c = this.read();
                        break;
                    }
                }
            }
            if (c == 34) {
                while (c != -1) {
                    c = this.in.read();
                    if (c == 92) {
                        c = this.in.read();
                        continue;
                    }
                    if (c != 34) continue;
                    c = this.read();
                    break;
                }
            }
            if (c == 39) {
                c = this.in.read();
                if (c == 92) {
                    c = this.in.read();
                }
                c = this.in.read();
                c = this.read();
            }
            return c;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int i = 0;
            while (i < len) {
                int c = this.read();
                if (c == -1) {
                    if (i == 0) {
                        return -1;
                    }
                    return i;
                }
                cbuf[off + i] = (char)c;
                ++i;
            }
            return len;
        }

        public long skip(long n) throws IOException {
            long i = 0L;
            while (i < n) {
                if (this.in.read() == -1) {
                    return i;
                }
                ++i;
            }
            return n;
        }
    }
}

