<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">


<HTML>
<HEAD>
     <TITLE>Edit Purchase Order</TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>


<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[
function displayHelp() {
  
  alert(" * When the SKU is left blank, the entry will be added to the current PO only. \n * If the SKU is entered the system will than try to look in the system to find the Item.\n * If a price is entered along with the SKU and the item was not found.  Than this will be entered into the system and on the PO.");      
  
}

function deleteConfirm() {
      var result = confirm("Are you sure you want to REMOVE the selected items?");
		
		if(result)
		{	
			POITEMS.DELETE.value='true';
			POITEMS.submit();
			return true;
		}	
      else
		{
			return false;
		}

}



function reCalc() {
	
	form = document.POITEMS;
   var field = form.ITEMTOTAL;  
   var items = form.elements;
   var length = items.length - 3;
	var sum = 0;
	var comSum = 0;
	var i = 23;

    if(length > 22)	
	{		
		
		while(i<length)
		{

		   if(items[i].value != '' 
				&& items[i+1].value == '') 
			{
			  items[i+1].value = items[i+7].value;	
			}
			
			
			if(items[i+1].value != '' 
				&& items[i].value == '') 
			{
				items[i].value = items[i+6].value;	
			}
			
			
			if(items[i].value != '' 
				&& items[i+1].value != '') 
			{
				items[i+2].value = items[i+1].value * items[i].value;	
			}
		
			i=i+7;	
   	}
	 }	
		calcTotal();
	}	   




function calcTotal() {
	
	form = document.POITEMS;
   var field = form.ITEMTOTAL;  
   var items = form.elements;
   var length = items.length - 3;
	var sum = 0;
	var i = 23;
   
	if(length > 22)
	{	
		while(i<length)
		{
			
			if(items[i+2].value == "")
			{
				sum = parseFloat(items[i+4].value) + sum;
		
			}
			else
			{
				sum = parseFloat(items[i+2].value) + sum;
			}
			i=i+7;	
   	}
	 	
		form.TOTALAMOUNT.value = '$' + sum*100/100;
	 }	   
  }



]]>
</xsl:comment>
</SCRIPT>


<BODY onLoad="reCalc();">


<FORM METHOD="POST" NAME="POITEMS">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>


<TABLE>

<!-- vertical button bar -->


<TR>

<TD><H1>PO #</H1></TD>

<TD><H1>
				<xsl:choose>
		        <xsl:when test="MSI/POINFOXML/POINFO/POInfoTable/otherpoidnum[.!='']">
					<xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/otherpoidnum"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/poidnum"/>  
				</xsl:otherwise>
				</xsl:choose>
</H1></TD>

<TD>
<INPUT TYPE="IMAGE" NAME="DISPLAYALL" SRC="/msi/graphics/complete_list.jpg"/>
</TD>

<TD>
<INPUT TYPE="IMAGE" NAME="DISPLAYCACHE" SRC="/msi/graphics/history.jpg"/>
</TD>

<TD>
<INPUT TYPE="IMAGE" NAME="FINISH" SRC="/msi/graphics/finish.jpg"/>
</TD>




</TR>





<TR>

<xsl:choose>
<xsl:when test="MSI/CLOSE[.!='']">
	<INPUT TYPE="HIDDEN" NAME="CLOSE" VALUE="true"></INPUT>
</xsl:when>
<xsl:otherwise>
	<INPUT TYPE="HIDDEN" NAME="CLOSE" VALUE=""></INPUT>
</xsl:otherwise>
</xsl:choose>

<INPUT TYPE="HIDDEN" NAME="disValue" VALUE="787"></INPUT>

<TABLE>

<xsl:choose>
<xsl:when test="MSI/POINFOXML/Message[.!='']">
<TR><FONT SIZE="4"><xsl:value-of select="MSI/POINFOXML/Message"/></FONT></TR> 
</xsl:when>
</xsl:choose>


<xsl:choose>
<xsl:when test="MSI/MESSAGE[.!='']">
<TR><FONT SIZE="4"><xsl:value-of select="MSI/MESSAGE"/></FONT></TR> 
</xsl:when>
</xsl:choose>



<TR><TD>Quanity</TD><TD><INPUT NAME="QUANITY" SIZE="10"></INPUT></TD></TR>
<TR><TD>SKU</TD><TD><INPUT NAME="SKU" SIZE="10"></INPUT></TD></TR>
<TR><TD>Description</TD><TD><INPUT NAME="DESCRIPTION" SIZE="30"></INPUT></TD></TR>
<TR><TD>Price</TD><TD><INPUT NAME="PRICE" SIZE="10"></INPUT></TD></TR>
<TR><TD>Commission</TD><TD><INPUT NAME="COMMISSION" SIZE="10"></INPUT></TD></TR>
<TR><TD>Catagory</TD><TD><INPUT NAME="CATAGORY" SIZE="15"></INPUT></TD></TR>
</TABLE>

<TABLE CELLPADDING="2" WIDTH="100%">


<TR><TD COLSPAN="2">
<INPUT TYPE="SUBMIT" NAME="ADDITEM" VALUE="Add above item"></INPUT>

<INPUT type="hidden" NAME="TOTALITEMS"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFOXML/POITEMS/FOOTER/TOTALCOUNT"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="SUPPLIERID"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/supplierid"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="SUPPLIERNAME"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/suppliername"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="PONUMBER"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/poidnum"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="CUSTOMERID"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/companyid"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="CONNECTION"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/c"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="customer"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/companyid"/>~displayPO</xsl:attribute></INPUT>
<INPUT type="hidden" NAME="DATE"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/dateordered"/></xsl:attribute></INPUT>


<P/>


<TABLE>
<TR class="EVANROW">


<TH><B>Customer</B></TH>
<TH><B>Supplier</B></TH>
<TH><B>Ship Date</B></TH>
<TH><B>Cancel Date</B></TH>
<TH><B>Terms</B></TH>
<TH><B>Instructions</B></TH>
</TR>


<TR CLASS="ODDROW">


<TD><xsl:value-of select="MSI/POINFOXML/COMPANYNAME"/></TD>

<TD><xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/suppliername"/></TD>

<TD>
<INPUT NAME="SHIPDATE" SIZE="10">
<xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/shipdate"/></xsl:attribute>
</INPUT>
</TD>

<TD>
<INPUT NAME="CANCELDATE" SIZE="10">
<xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/canceldate"/></xsl:attribute>
</INPUT>
</TD>


<TD>
<INPUT NAME="TERMS" SIZE="10">
<xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/terms"/></xsl:attribute>
</INPUT>
</TD>


<TD>
<INPUT NAME="INSTRUCTIONS" SIZE="20">
<xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/instruct"/></xsl:attribute>
</INPUT>
</TD>
</TR>
</TABLE>

<TABLE>

<TR CLASS="ODDROW">

<TD>Additional Notes:</TD>
<TD>
<INPUT NAME="NOTES" SIZE="20">
<xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFOXML/POINFO/POInfoTable/notes"/></xsl:attribute>
</INPUT>
</TD>
</TR>
</TABLE>


<P></P>


<TABLE>

<xsl:choose>
<xsl:when test="MSI/POINFOXML/POITEMS/POItemTable[.!='']">
	
		<TR>
			<TH></TH>
			<TH>Item ID</TH>
			<TH>Item Description</TH>
			<TH>Price</TH>
			<TH>Quanity</TH>
			<TH>Total Price</TH>
		</TR>
</xsl:when>
</xsl:choose>
		
		<xsl:for-each select="MSI/POINFOXML/POITEMS/POItemTable">
		   <TR>
			    <xsl:choose>
			    <xsl:when test="position() mod 2 = 1">
		   	    <xsl:attribute name="CLASS">ODDROW</xsl:attribute>
			    </xsl:when>
			    <xsl:otherwise>
				    <xsl:attribute name="CLASS">EVENROW</xsl:attribute>
			    </xsl:otherwise>
			    </xsl:choose>			
				
				
				<TD><INPUT TYPE="CheckBox">
					<xsl:attribute name="NAME">item<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="description"/></xsl:attribute>
				     </INPUT></TD>
				<TD><xsl:value-of select="sku"/></TD>
				<TD><xsl:value-of select="description"/></TD>
		
				<TD><INPUT SIZE="8" onChange="reCalc();" ALIGN="right">
				<xsl:attribute name="VALUE"><xsl:value-of select="orderprice"/></xsl:attribute>
				<xsl:attribute name="NAME">price<xsl:value-of select="c1"/></xsl:attribute>
				</INPUT></TD>

				<TD ALIGN="center"><INPUT SIZE="4" onChange="reCalc();">
				<xsl:attribute name="VALUE"><xsl:value-of select="orderquanity"/></xsl:attribute>
				<xsl:attribute name="NAME">quan<xsl:value-of select="c1"/></xsl:attribute>
				</INPUT></TD>

				<TD ALIGN="right"><INPUT SIZE="10" onChange="calcTotal();">
				<xsl:attribute name="VALUE"><xsl:value-of select="ordertotal"/></xsl:attribute>
				<xsl:attribute name="NAME">total<xsl:value-of select="c1"/></xsl:attribute>
				</INPUT></TD>
				

				<INPUT TYPE="HIDDEN">
					<xsl:attribute name="NAME">desc<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="description"/></xsl:attribute>
				</INPUT>

				<INPUT TYPE="HIDDEN">
					<xsl:attribute name="NAME">sku<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="sku"/></xsl:attribute>
				</INPUT>

				<INPUT TYPE="HIDDEN">
					<xsl:attribute name="NAME">com<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="commission"/></xsl:attribute>
				</INPUT>


			</TR>
		</xsl:for-each>

<xsl:choose>
<xsl:when test="MSI/POINFOXML/POITEMS/POItemTable[.!='']">

<TR>
<TD/><TD/><TD/><TD/><TD>Total</TD><TD ALIGN="RIGHT"><INPUT TYPE="TEXT" NAME="TOTALAMOUNT" VALUE="" readonly="yes" SIZE="10"></INPUT></TD>
</TR>	

</xsl:when>
</xsl:choose>

</TABLE>
<TABLE>
<TR>

<TD>
<xsl:choose>
<xsl:when test="MSI/POINFOXML/POITEMS/POItemTable[.!='']">

<INPUT TYPE="HIDDEN" NAME="DELETE" VALUE="FALSE"/>
<INPUT TYPE="BUTTON" NAME="DELETESTUFF" VALUE="Remove Selected Items" onClick="deleteConfirm();"></INPUT>
</xsl:when>
</xsl:choose>
</TD>

</TR>
</TABLE>

</TD></TR></TABLE>

</TR>



</TABLE>

</FORM>




</BODY></HTML>
</xsl:template>
</xsl:stylesheet>
