;;;Program      :   LSPFUN14.lsp v14.1.00 (c)1999
;;;Created by   :   Augusto Mendoza Macalalad
;;;Postal Address:  47 Carlton Crescent, Summer Hill, NSW 2130, AUSTRALIA
;;;Email Address:   augustom@fdcbuilding.com.au  &  ammacalalad@angelfire.com
;;;
;;;Date created :   JANUARY 22, 1999
;;;Last update  :   14:58 20/08/99 ; 8:54 26/08/99
;;;
;;;Function: Recall forgotten loaded AutoLISP(c)(tm) routine (not sub-routine)
;;;          functions via dialog box for easy execution.  For AutoCAD r14 or higher
;;;
;;;NOTE: This is freeware but A US$5.00 cash donation is greatly appreciated
;;;      to help me create and develop more useful AutoLISP routines.
;;;      THANK YOU and GOD BLESS YOU!
;;;
;;;Permission to use, copy, modify, and distribute this software
;;;for any purpose is hereby granted, provided that the above notice appears
;;;in all copies. This program is provided "as is" and with all faults.
;;;The author does not warrant that the operation of the program will be error free.
;;;
;;;AutoCAD and AutoLISP copyrighted and trademark of Autodesk Inc.
;;;
;;;REVISIONS:
;;;
;;;1.00   9:23 22/08/99   Initial issue  
;;;1.01   8:47 26/08/99   Error trap added
;;;
;;
  (defun lf_err (msg) ; If an error (such as CTRL-C) occurs
                       ; while this command is active...
    (if (/= msg "Function cancelled")
      (if (= msg "quit / exit abort")
          (prompt "Exiting...") (prompt (strcat "\nError: " msg))
      )
   )
    (princ)
  )
;;

;;;
(defun DefunIt ()
  (setq WFILE (open (strcat (getvar "tempprefix") "TEMPFUNC.LSP") "w"))
  (write-line "(defun C:GoForIt ()" WFILE)
  (setq DO_IT (nth SEL# DFList))
  (setq NewLine (strcat "(command (" DO_IT "))"))
  (write-line NewLine WFILE) (write-line "(princ))" WFILE)
  (close WFILE)
  (load (strcat (getvar "tempprefix") "TEMPFUNC.lsp"))
  (C:GoForIt)
)
;;;
(defun ShowReadMe ()
  (setq RMFILE (open (findfile "LSPFUN14.TXT") "r"))
  (setq RMList (list (read-line RMFILE)))
  (while (/= (setq RMLINE (read-line RMFILE)) nil)
    (setq RMLIST (append (list RMLINE) RMLIST))
  )
  (close RMFILE)
  (setq RMList (reverse RMList))
  (setq dcl_id (load_dialog "lspfun14.dcl"))
  (if (not (new_dialog  "view_readme"   dcl_id)) (exit))
  (start_list "readme_list") (mapcar 'add_list RMList) (end_list)
  (action_tile  "cancel"  "(setq what_next 100)" )
  (start_dialog)
)
;;;
(defun GetDefuns ()  ;gathers all the C:DEFUNS that are loaded into memory
 (setq DFList (list))  ;null list
 (setq AllFunc (atoms-family 1))  ;get it now
 (setq AFnum (length AllFunc))
 (foreach ITEM AllFunc
    (if (= (substr ITEM 1 2) "C:") (setq DFList (append DFList (list ITEM))))
 )
 (setq DFLIST (acad_strlsort DFLIST))  ;sorts it alphabetically/ascending
 (setq ListNum (length DFLIST))
)
;;;
(defun C:LF()
 (setq OLDERR *error* *error* lf_err)
 (setq OMS (getvar "maxsort") OCE (getvar "cmdecho") what_next 100)
 (setvar "maxsort" 20000)  (setvar "cmdecho" 0)
 (setq AllFuncNew (atoms-family 1))  ;get it now
 (setq AFnumNew (1- (length AllFuncNew)))
 (if (= DFLIST nil) (GetDefuns))  ;if there is no list yet, create new list
 (if (> AFNumNew AFNum) (GetDefuns))  ;  if a new LISP has been loaded, refresh list
 (while (> what_next 10)
 (setq dcl_id (load_dialog "lspfun14.dcl"))
 (if (not (new_dialog  "lspfun14"   dcl_id)) (exit))
   (set_tile "numc" (strcat "Total = " (rtos ListNum 2 0) " functions..."))
   (start_list "df_sel") (mapcar 'add_list DFList) (end_list)
   (action_tile "df_sel" "(setq sel# (atoi $value))(setq FLAG 1) (setq what_next 0)(done_dialog 1)")
   (action_tile  "readme"  "(setq FLAG 3)(done_dialog 1)" )
   (action_tile  "emailme"  "(setq FLAG 2)(done_dialog 0)" )
   (action_tile  "cancel"  "(setq FLAG 0) (setq what_next 0)(done_dialog 0)" )
 (start_dialog) (unload_dialog dcl_id)
 (cond
   ((= FLAG 3)  (ShowReadMe))
   ((= FLAG 2)  (command "_browser" "mailto:augustom@fdcbuilding.com.au"))
   ((= FLAG 1)  (DefunIt))
   ((= FLAG 0)  (alert "LSPFUN14.lsp by Augusto Macalalad\nIf you like this routine, a donation of \nUS$5.00 CASH is greatly appreciated\n\n47 Carlton Crescent\nSummer Hill, NSW 2130\nAustralia\n\nE-mail: augustom@fdcbuilding.com.au\n\nAll proceeds will be use to develop\nmore useful AutoLISP routines...\nTHANK YOU and GOD BLESS YOU!"))
 )
 )
 (setvar "maxsort" OMS)  (setvar "cmdecho" 1)
 (setq *error* OLDERR)
 (princ)
)
(prompt "\nLSPFUN14.lsp loaded, type LF at command prompt")
(princ)
;;;
;;;end of file
;;;JESUS IS LORD
;;;