#include <stdio.h>
#include <string.h>

#define InsertPoint 46
#define LineLen 130

void main(void)
{
   FILE * in;
   FILE * out;
   char str1[LineLen],
        str2[LineLen+2];

   printf("BIRTHDAY SCANNER v1.2  (Convertor Utility)\n");
   printf("Converts datafile BIRTHDAY.TXT from old 1.1 to new 1.2 version.\n");

   if (rename("birthday.txt","birthday.tx1") != 0)
   {
      printf("Can't rename old datafile BIRTHDAY.TXT to BIRTHDAY.TX1...");
      return;
   }

   if ( (in = fopen("birthday.tx1","rt")) == NULL )
   {
      printf("Can't open old datafile BIRTHDAY.TXT...");
      return;
   }

   if ( (out = fopen("birthday.txt","w+t")) == NULL)
   {
      printf("Can't open old datafile BIRTHDAY.TXT...");
      return;
   }


   while (!feof(in))
   {
      fgets(str1,LineLen,in);

      if (strlen(str1)>InsertPoint)
      {
         memcpy(str2,str1,InsertPoint);
         str2[InsertPoint] = '1';
         str2[InsertPoint+1] = '9';
         memcpy(str2+InsertPoint+2,str1+InsertPoint,LineLen-InsertPoint);
         fputs(str2,out);
      }
   }

   fclose(out);
   fclose(in);

   printf("Datafile BIRTHDAY.TXT was successfully converted!\n");

   if (remove("birthday.tx1") != 0)
   {
      printf("Can't remove old datafile BIRTHDAY.TX1...");
   }

}
