/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallListener;
import com.izforge.izpack.installer.ScriptParser;
import com.izforge.izpack.installer.VariableSubstitutor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStreamWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Unpacker
extends Thread {
    private InstallData idata;
    private InstallListener listener;
    private ArrayList log;
    private String jarLocation;
    private VariableSubstitutor vs;

    public void run() {
        try {
            this.listener.startUnpack();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList arrayList2 = this.idata.selectedPacks;
            int n = arrayList2.size();
            this.log = new ArrayList();
            if (this.idata.kind.equalsIgnoreCase("web") || this.idata.kind.equalsIgnoreCase("web-kunststoff")) {
                InputStream inputStream = this.getClass().getResourceAsStream("/res/WebInstallers.url");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                this.jarLocation = bufferedReader.readLine();
            }
            int n2 = 0;
            while (n2 < n) {
                Object object;
                int n3 = this.idata.availablePacks.indexOf(arrayList2.get(n2));
                ObjectInputStream objectInputStream = new ObjectInputStream(this.getPackAsStream(n3));
                int n4 = objectInputStream.readInt();
                this.listener.changeUnpack(0, n4, ((Pack)arrayList2.get((int)n2)).name);
                int n5 = 0;
                while (n5 < n4) {
                    PackFile packFile = (PackFile)objectInputStream.readObject();
                    object = this.translatePath(packFile.targetPath);
                    File file = new File((String)object);
                    String string = file.getName();
                    int n6 = string.length();
                    File file2 = file.getParentFile();
                    if (!file2.exists()) {
                        file2.mkdirs();
                    }
                    this.log.add(object);
                    FileOutputStream fileOutputStream = new FileOutputStream((String)object);
                    this.listener.progressUnpack(n5, (String)object);
                    byte[] byArray = new byte[5120];
                    long l = 0L;
                    while (l < packFile.length) {
                        int n7 = packFile.length - l < (long)byArray.length ? (int)(packFile.length - l) : byArray.length;
                        int n8 = objectInputStream.read(byArray, 0, n7);
                        if (n8 == -1) {
                            throw new IOException("Unexpected end of stream");
                        }
                        fileOutputStream.write(byArray, 0, n8);
                        l += (long)n8;
                    }
                    fileOutputStream.close();
                    ++n5;
                }
                n5 = objectInputStream.readInt();
                int n9 = 0;
                while (n9 < n5) {
                    object = (ParsableFile)objectInputStream.readObject();
                    ((ParsableFile)object).path = this.translatePath(((ParsableFile)object).path);
                    arrayList.add(object);
                    ++n9;
                }
                objectInputStream.close();
                ++n2;
            }
            ScriptParser scriptParser = new ScriptParser(arrayList, this.vs);
            scriptParser.parseFiles();
            this.putUninstaller();
            this.listener.stopUnpack();
        }
        catch (Exception exception) {
            this.listener.stopUnpack();
            this.listener.errorUnpack(exception.toString());
        }
    }

    private void putUninstaller() throws Exception {
        int n;
        String string = this.translatePath("$USER_HOME") + File.separator + "." + this.idata.info.getAppName() + "-uninstaller";
        String string2 = string + File.separator + "uninstaller.jar";
        File file = new File(string);
        file.mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        zipOutputStream.setLevel(9);
        this.log.add(string2);
        InputStream inputStream = this.getClass().getResourceAsStream("/res/IzPack.uninstaller");
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
            n = ((InflaterInputStream)zipInputStream).read();
            while (n != -1) {
                zipOutputStream.write(n);
                n = ((InflaterInputStream)zipInputStream).read();
            }
            zipInputStream.closeEntry();
            zipOutputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
        inputStream = this.getClass().getResourceAsStream("/langpacks/" + this.idata.localeISO3 + ".xml");
        zipOutputStream.putNextEntry(new ZipEntry("langpack.xml"));
        n = inputStream.read();
        while (n != -1) {
            zipOutputStream.write(n);
            n = inputStream.read();
        }
        zipOutputStream.closeEntry();
        zipOutputStream.putNextEntry(new ZipEntry("install.log"));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
        int n2 = this.log.size();
        int n3 = n2 - 1;
        bufferedWriter.write(this.idata.installPath);
        bufferedWriter.newLine();
        int n4 = 0;
        while (n4 < n2) {
            bufferedWriter.write((String)this.log.get(n4));
            if (n4 != n3) {
                bufferedWriter.newLine();
            }
            ++n4;
        }
        bufferedWriter.flush();
        zipOutputStream.closeEntry();
        ((FilterOutputStream)zipOutputStream).flush();
        zipOutputStream.close();
    }

    private InputStream getPackAsStream(int n) throws Exception {
        InputStream inputStream = null;
        if (this.idata.kind.equalsIgnoreCase("standard") || this.idata.kind.equalsIgnoreCase("standard-kunststoff")) {
            inputStream = this.getClass().getResourceAsStream("/packs/pack" + n);
        } else if (this.idata.kind.equalsIgnoreCase("web") || this.idata.kind.equalsIgnoreCase("web-kunststoff")) {
            URL uRL = new URL("jar:" + this.jarLocation + "!/packs/pack" + n);
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            inputStream = jarURLConnection.getInputStream();
        }
        return inputStream;
    }

    private String translatePath(String string) {
        string = this.vs.substitute(string, null);
        return string.replace('/', File.separatorChar);
    }

    public Unpacker(InstallData installData, InstallListener installListener) {
        super("IzPack - Unpacker thread");
        this.idata = installData;
        this.listener = installListener;
        HashMap<String, String> hashMap = new HashMap<String, String>(installData.translatableVariables);
        hashMap.put("INSTALL_PATH", installData.installPath);
        hashMap.put("JAVA_HOME", System.getProperty("java.home"));
        hashMap.put("USER_HOME", System.getProperty("user.home"));
        hashMap.put("USER_NAME", System.getProperty("user.name"));
        this.vs = new VariableSubstitutor(hashMap);
    }
}

