VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDeck"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'///////////////////////////////////////////////////////////
'// The clsDeck class
'///////////////////////////////////////////////////////////

Option Explicit

Private m_Hands(MAXHANDS) As hand
Private m_Cards(51) As clsCard
Private m_PositionInDeck As Integer
Private m_NumCardsInHand As Integer

'///////////////////////////////////////////////////////////
'// Class_Initialize
'///////////////////////////////////////////////////////////
Private Sub Class_Initialize()
  Dim i As Integer

  Randomize
  m_PositionInDeck = 0
  For i = 0 To 51
    Set m_Cards(i) = New clsCard
    m_Cards(i).value = i
  Next i
  Init_Hands
End Sub

'///////////////////////////////////////////////////////////
'// Shuffle
'//
'// This subroutine shuffles the deck, resets the
'// m_PositionInDeck marker, and initializes the m_Hands.
'///////////////////////////////////////////////////////////
Sub Shuffle()
  Dim CardNum As Integer
  Dim temp As clsCard
  Dim i As Integer

  m_PositionInDeck = 0
  For i = 0 To 51
    CardNum = Int(Rnd * 52)
    Set temp = m_Cards(i)
    Set m_Cards(i) = m_Cards(CardNum)
    Set m_Cards(CardNum) = temp
  Next i
  Init_Hands
End Sub

'///////////////////////////////////////////////////////////
'// Deal
'//
'// This subroutine deals num cards into the given hand,
'// displaying the cards on screen starting at x,y and
'// spacing them each one card width over plus the spacing
'// parameter. The parameter face controls whether the cards
'// are dealt face up or face down.
'///////////////////////////////////////////////////////////
Sub Deal(num As Integer, hand As Integer, X As Integer, _
    Y As Integer, spacing As Integer, face As Integer)
  Dim pos As Integer
  Dim i As Integer

  For i = 0 To num - 1
    pos = m_Hands(hand).PositionInHand
    Set m_Hands(hand).cards(pos) = m_Cards(m_PositionInDeck)
    m_Cards(m_PositionInDeck).Display X, Y, face
    m_PositionInDeck = m_PositionInDeck + 1
    If m_PositionInDeck > 51 Then m_PositionInDeck = 0
    m_Hands(hand).PositionInHand = _
        m_Hands(hand).PositionInHand + 1
    If m_Hands(hand).PositionInHand > 51 Then _
         m_Hands(hand).PositionInHand = 0
    X = X + 56 + spacing
  Next i
End Sub

'///////////////////////////////////////////////////////////
'// ShowHand
'//
'// This subroutine shows all the cards in the given hand
'// starting at the screen coordinates x,y and spaced
'// apart according to the spacing parameter. The cards
'// are displayed face up or face down depending on the
'// face parameter.
'///////////////////////////////////////////////////////////
Sub ShowHand(hand As Integer, X As Integer, Y As Integer, _
     spacing As Integer, face As Integer)
  Dim num As Integer
  Dim i As Integer

  num = m_Hands(hand).PositionInHand
  For i = 0 To num - 1
    m_Hands(hand).cards(i).Display X, Y, face
    X = X + 56 + spacing
  Next i
End Sub

'///////////////////////////////////////////////////////////
'// DealReplace
'//
'// This subroutine deals one card into the given hand,
'// replacing the card at the position pos. The parameter
'// face controls whether the card is displayed face up
'// or face down.
'///////////////////////////////////////////////////////////
Sub DealReplace(hand As Integer, pos As Integer, _
    face As Integer)
  Dim X As Integer
  Dim Y As Integer

  X = m_Hands(hand).cards(pos).xPosition
  Y = m_Hands(hand).cards(pos).yPosition
  Set m_Hands(hand).cards(pos) = m_Cards(m_PositionInDeck)
  m_Cards(m_PositionInDeck).Display X, Y, face
  m_PositionInDeck = m_PositionInDeck + 1
  If m_PositionInDeck > 51 Then m_PositionInDeck = 0
End Sub

'///////////////////////////////////////////////////////////
'// Discard
'//
'// This subroutine removes the card at position pos from
'// the hand specified bt the hand parameter.
'///////////////////////////////////////////////////////////
Sub Discard(hand As Integer, pos As Integer)
  Dim X As Integer
  Dim Y As Integer
  Dim DiscardPos As Integer
  Dim i As Integer
  
  DiscardPos = m_Hands(MAXHANDS - 1).PositionInHand
  m_Hands(MAXHANDS - 1).PositionInHand = _
      m_Hands(MAXHANDS - 1).PositionInHand + 1
  Set m_Hands(MAXHANDS - 1).cards(DiscardPos) = _
      m_Hands(hand).cards(pos)
  For i = pos To m_Hands(hand).PositionInHand - 1
    Set m_Hands(hand).cards(i) = m_Hands(hand).cards(i + 1)
  Next i
  m_Hands(hand).PositionInHand = m_Hands(hand).PositionInHand - 1
End Sub

'///////////////////////////////////////////////////////////
'// EraseCard
'//
'// This subroutine erases the card at position pos in
'// the hand specified by the hand parameter.
'///////////////////////////////////////////////////////////
Sub EraseCard(HandNum As Integer, pos As Integer)
  m_Hands(HandNum).cards(pos).EraseCard
End Sub

'///////////////////////////////////////////////////////////
'// ShowHandCard
'//
'// This subroutine displays the card at position pos in
'// the given hand. The parameter face controls whether
'// the card is displayed face up or face down.
'///////////////////////////////////////////////////////////
Sub ShowHandCard(hand As Integer, pos As Integer, _
    face As Integer)
  If face = FaceUp Then
    m_Hands(hand).cards(pos).ShowFace
  Else
    m_Hands(hand).cards(pos).ShowBack
  End If
End Sub

'///////////////////////////////////////////////////////////
'// MoveHandCard
'//
'// This subroutine moves the card at position pos in the
'// given hand to new screen coordinates. The parameter
'// face controls whether the card is displayed face up or
'// face down.
'///////////////////////////////////////////////////////////
Sub MoveHandCard(hand As Integer, pos As Integer, _
    X As Integer, Y As Integer, face As Integer)
  m_Hands(hand).cards(pos).Display X, Y, face
End Sub

'///////////////////////////////////////////////////////////
'// GetCardValue
'//
'// This function returns the value of the card at pos in
'// the given hand. The value is a number from 0 to 51.
'///////////////////////////////////////////////////////////
Function GetCardValue(hand As Integer, _
    pos As Integer) As Integer
  GetCardValue = m_Hands(hand).cards(pos).value
End Function

'///////////////////////////////////////////////////////////
'// Init_Hands
'//
'// This subroutine initializes the m_Hands property,
'// setting all cards in m_Hands to Nothing and setting
'// each hand's PositionInHand property to zero.
'///////////////////////////////////////////////////////////
Sub Init_Hands()
  Dim i As Integer
  Dim j As Integer
  
  For i = 0 To MAXHANDS - 1
    m_Hands(i).PositionInHand = 0
    For j = 0 To 51
      Set m_Hands(i).cards(j) = Nothing
    Next j
  Next i
End Sub

'///////////////////////////////////////////////////////////
'// Restore
'//
'// This subroutine sets the position in the deck back to
'// the beginning of the deck.
'///////////////////////////////////////////////////////////
Sub Restore()
  m_PositionInDeck = 0
End Sub

'///////////////////////////////////////////////////////////
'// Get NumCardsInHand
'///////////////////////////////////////////////////////////
Property Get NumCardsInHand(hand As Integer) As Integer
  If hand < 0 Or hand > MAXHANDS - 1 Then Err.Raise 9
  NumCardsInHand = m_Hands(hand).PositionInHand
End Property

