/*
 * Decompiled with CFR 0.152.
 */
package com.rexbot.game.card;

import com.rexbot.game.card.Hand;
import com.rexbot.game.card.Opts;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;
import org.apache.log4j.Category;

public class Card
extends JPanel {
    private static Category cat = Category.getInstance(class$com$rexbot$game$card$Card == null ? (class$com$rexbot$game$card$Card = Card.class$("com.rexbot.game.card.Card")) : class$com$rexbot$game$card$Card);
    public static int CARD_WIDTH = 80;
    public static int CARD_HEIGHT = 105;
    private static Hashtable imageIcons = new Hashtable(52);
    private JPanel cardImage = this;
    private JPanel backImage = this;
    private static ImageIcon clubImage = null;
    private static ImageIcon spadeImage = null;
    private static ImageIcon heartImage = null;
    private static ImageIcon diamondImage = null;
    private static Image smallClub = null;
    private static Image smallSpade = null;
    private static Image smallHeart = null;
    private static Image smallDiamond = null;
    private static Image normalClub = null;
    private static Image normalSpade = null;
    private static Image normalHeart = null;
    private static Image normalDiamond = null;
    private static Image largeClub = null;
    private static Image largeSpade = null;
    private static Image largeHeart = null;
    private static Image largeDiamond = null;
    private static final String SPADE_IMAGE = "/spade.png";
    private static final String CLUB_IMAGE = "/club.png";
    private static final String HEART_IMAGE = "/heart.png";
    private static final String DIAMOND_IMAGE = "/diamond.png";
    public static final int HEART = 0;
    public static final int CLUB = 1;
    public static final int SPADE = 2;
    public static final int DIAMOND = 3;
    public static final int ACE = 1;
    public static final int TWO = 2;
    public static final int THREE = 3;
    public static final int FOUR = 4;
    public static final int FIVE = 5;
    public static final int SIX = 6;
    public static final int SEVEN = 7;
    public static final int EIGHT = 8;
    public static final int NINE = 9;
    public static final int TEN = 10;
    public static final int JACK = 11;
    public static final int QUEEN = 12;
    public static final int KING = 13;
    private int suit;
    private int value;
    private boolean sideWays = false;
    private Hand hand;
    private static MatteBorder border = null;
    private static MatteBorder backBorder = null;
    private static boolean resetGraphic = false;
    static /* synthetic */ Class class$com$rexbot$game$card$Card;

    public static void resetGraphic() {
        resetGraphic = true;
    }

    public static boolean isResetGraphic() {
        return resetGraphic;
    }

    public Card(int suit, int value) {
        ImageIcon ii;
        URL url;
        this.suit = suit;
        this.value = value;
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.setOpaque(false);
        if (border == null) {
            url = this.getClass().getResource("/cardBorder.png");
            ii = new ImageIcon(new ImageIcon(url).getImage().getScaledInstance(CARD_WIDTH, CARD_HEIGHT, 4));
            border = new MatteBorder(ii);
        }
        if (backBorder == null || resetGraphic) {
            resetGraphic = false;
            url = this.getClass().getResource("/cardBack_" + Opts.getInstance().getCardSet() + ".png");
            ii = new ImageIcon(new ImageIcon(url).getImage().getScaledInstance(CARD_WIDTH, CARD_HEIGHT, 4));
            backBorder = new MatteBorder(ii);
        }
        if (spadeImage == null) {
            url = this.getClass().getResource(SPADE_IMAGE);
            spadeImage = new ImageIcon(url);
            smallSpade = spadeImage.getImage().getScaledInstance(8, 8, 4);
            largeSpade = spadeImage.getImage().getScaledInstance(40, 40, 4);
            normalSpade = spadeImage.getImage().getScaledInstance(16, 16, 4);
        }
        if (clubImage == null) {
            url = this.getClass().getResource(CLUB_IMAGE);
            clubImage = new ImageIcon(url);
            smallClub = clubImage.getImage().getScaledInstance(8, 8, 4);
            largeClub = clubImage.getImage().getScaledInstance(40, 40, 4);
            normalClub = clubImage.getImage().getScaledInstance(16, 16, 4);
        }
        if (heartImage == null) {
            url = this.getClass().getResource(HEART_IMAGE);
            heartImage = new ImageIcon(url);
            smallHeart = heartImage.getImage().getScaledInstance(8, 8, 4);
            largeHeart = heartImage.getImage().getScaledInstance(40, 40, 4);
            normalHeart = heartImage.getImage().getScaledInstance(16, 16, 4);
        }
        if (diamondImage == null) {
            url = this.getClass().getResource(DIAMOND_IMAGE);
            diamondImage = new ImageIcon(url);
            smallDiamond = diamondImage.getImage().getScaledInstance(8, 8, 4);
            largeDiamond = diamondImage.getImage().getScaledInstance(40, 40, 4);
            normalDiamond = diamondImage.getImage().getScaledInstance(16, 16, 4);
        }
        this.setSize(CARD_WIDTH, CARD_HEIGHT);
        this.makeCard();
        this.setSideWays(false);
        this.setToolTipText(this.toString());
    }

    private void makeCard() {
        JPanel numberPanel = new JPanel(new GridBagLayout());
        numberPanel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 0, 5);
        JLabel label = null;
        switch (this.getValue()) {
            case 1: {
                label = new JLabel("A");
                break;
            }
            case 11: {
                label = new JLabel("J");
                break;
            }
            case 12: {
                label = new JLabel("Q");
                break;
            }
            case 13: {
                label = new JLabel("K");
                break;
            }
            default: {
                label = new JLabel(Integer.toString(this.getValue()));
            }
        }
        switch (this.getSuit()) {
            case 1: {
                label.setForeground(Color.black);
                break;
            }
            case 3: {
                label.setForeground(Color.red);
                break;
            }
            case 0: {
                label.setForeground(Color.red);
                break;
            }
            case 2: {
                label.setForeground(Color.black);
            }
        }
        numberPanel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 2;
        Image image = null;
        switch (this.getSuit()) {
            case 1: {
                image = smallClub;
                break;
            }
            case 3: {
                image = smallDiamond;
                break;
            }
            case 0: {
                image = smallHeart;
                break;
            }
            case 2: {
                image = smallSpade;
            }
        }
        numberPanel.add((Component)new JLabel(new ImageIcon(image)), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 2;
        gbc.ipady = 10;
        this.add((Component)numberPanel, gbc);
        switch (this.getValue()) {
            case 1: {
                this.addAceFace();
                break;
            }
            case 11: {
                this.addFace();
                break;
            }
            case 12: {
                this.addFace();
                break;
            }
            case 13: {
                this.addFace();
                break;
            }
            default: {
                this.addPips();
            }
        }
        this.validate();
        this.repaint();
    }

    private void addAceFace() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 10.0;
        gbc.weightx = 10.0;
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        Image image = null;
        switch (this.getSuit()) {
            case 1: {
                image = largeClub;
                break;
            }
            case 3: {
                image = largeDiamond;
                break;
            }
            case 0: {
                image = largeHeart;
                break;
            }
            case 2: {
                image = largeSpade;
            }
        }
        this.add((Component)new JLabel(new ImageIcon(image)), gbc);
    }

    private void addFace() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.ipady = 10;
        JLabel label = null;
        switch (this.getValue()) {
            case 1: {
                label = new JLabel("A");
                break;
            }
            case 11: {
                label = new JLabel("J");
                break;
            }
            case 12: {
                label = new JLabel("Q");
                break;
            }
            case 13: {
                label = new JLabel("K");
                break;
            }
            default: {
                label = new JLabel(Integer.toString(this.getValue()));
            }
        }
        switch (this.getSuit()) {
            case 1: {
                label.setForeground(Color.black);
                break;
            }
            case 3: {
                label.setForeground(Color.red);
                break;
            }
            case 0: {
                label.setForeground(Color.red);
                break;
            }
            case 2: {
                label.setForeground(Color.black);
            }
        }
        label.setFont(new Font("SansSerif", 1, 48));
        this.add((Component)label, gbc);
    }

    private void addPips() {
        int row = 1;
        int col = 2;
        for (int i = 0; i < this.getValue(); ++i) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.weighty = 1.0;
            gbc.gridx = col;
            gbc.gridy = row;
            gbc.ipady = 10;
            switch (this.getSuit()) {
                case 1: {
                    this.add((Component)new JLabel(new ImageIcon(normalClub)), gbc);
                    break;
                }
                case 3: {
                    this.add((Component)new JLabel(new ImageIcon(normalDiamond)), gbc);
                    break;
                }
                case 0: {
                    this.add((Component)new JLabel(new ImageIcon(normalHeart)), gbc);
                    break;
                }
                case 2: {
                    this.add((Component)new JLabel(new ImageIcon(normalSpade)), gbc);
                }
            }
            if (++col <= 4) continue;
            col = 2;
            ++row;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 10.0;
        gbc.weighty = 10.0;
        gbc.gridx = 99;
        gbc.gridy = 99;
        this.add((Component)new JLabel(""), gbc);
    }

    public void cardMouseClicked(MouseEvent evt) {
        if ((evt.getModifiers() & 0x10) != 0) {
            this.getHand().getTable().dealCard();
        }
        if ((evt.getModifiers() & 4) != 0) {
            // empty if block
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.hand.getPlayer() == null) {
            border.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            super.paint(g2d);
        } else if (!this.hand.getPlayer().isFolded()) {
            if (this.hand.isFaceUp()) {
                border.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
                super.paint(g2d);
            } else {
                backBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    public ImageIcon getImageIcon(String key) {
        ImageIcon ii = (ImageIcon)imageIcons.get(key);
        if (ii == null) {
            URL url = this.getClass().getResource(key);
            ii = new ImageIcon(url);
            imageIcons.put(key, ii);
        }
        return ii;
    }

    public String getCardFile(int suit, int value) {
        StringBuffer sb = new StringBuffer(3);
        if (value < 10) {
            sb.append("0");
        }
        sb.append(Integer.toString(value));
        switch (suit) {
            case 1: {
                sb.append("c");
                break;
            }
            case 3: {
                sb.append("d");
                break;
            }
            case 0: {
                sb.append("h");
                break;
            }
            case 2: {
                sb.append("s");
            }
        }
        return sb.toString();
    }

    public int getSuit() {
        return this.suit;
    }

    public void setSuit(int suit) {
        this.suit = suit;
    }

    public int getAceHighValue() {
        switch (this.getValue()) {
            case 1: {
                return 11;
            }
            case 11: {
                return 10;
            }
            case 12: {
                return 10;
            }
            case 13: {
                return 10;
            }
        }
        return this.getValue();
    }

    public int getAceLowValue() {
        switch (this.getValue()) {
            case 1: {
                return 1;
            }
            case 11: {
                return 10;
            }
            case 12: {
                return 10;
            }
            case 13: {
                return 10;
            }
        }
        return this.getValue();
    }

    public int getValue() {
        return this.value;
    }

    public int getPokerValue() {
        if (this.getValue() == 1) {
            return 14;
        }
        return this.getValue();
    }

    public void setValue(int value) {
        this.value = value;
    }

    public boolean isSideWays() {
        return this.sideWays;
    }

    public void setSideWays(boolean sideWays) {
        this.sideWays = sideWays;
    }

    public int getOverlay() {
        return this.getWidth() / 4;
    }

    public Hand getHand() {
        return this.hand;
    }

    public void setHand(Hand hand) {
        this.hand = hand;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(10);
        switch (this.getValue()) {
            case 1: {
                sb.append("Ace");
                break;
            }
            case 11: {
                sb.append("Jack");
                break;
            }
            case 12: {
                sb.append("Queen");
                break;
            }
            case 13: {
                sb.append("King");
                break;
            }
            default: {
                sb.append(this.getValue());
            }
        }
        sb.append(" of ");
        switch (this.getSuit()) {
            case 1: {
                sb.append("Clubs");
                break;
            }
            case 3: {
                sb.append("Diamonds");
                break;
            }
            case 0: {
                sb.append("Hearts");
                break;
            }
            case 2: {
                sb.append("Spades");
            }
        }
        return sb.toString();
    }

    public static Comparator getComparator() {
        return new Comparator(){

            public int compare(Object one, Object two) {
                int cardTwo;
                int cardOne = ((Card)one).getPokerValue();
                if (cardOne < (cardTwo = ((Card)two).getPokerValue())) {
                    return -1;
                }
                if (cardOne > cardTwo) {
                    return 1;
                }
                return 0;
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

