/*
 * Decompiled with CFR 0.152.
 */
package com.rexbot.game.card;

import com.rexbot.game.card.Brain;
import com.rexbot.game.card.Card;
import com.rexbot.game.card.HelpDialog;
import com.rexbot.game.card.History;
import com.rexbot.game.card.Main;
import com.rexbot.game.card.Opts;
import com.rexbot.game.card.Palette;
import com.rexbot.game.card.Player;
import com.rexbot.game.card.PlayerManager;
import com.rexbot.game.card.Shoe;
import com.rexbot.game.card.Table;
import com.rexbot.game.card.commands.NewGameCommand;
import com.rexbot.game.card.commands.RunSimCommand;
import java.awt.Color;
import java.awt.Frame;
import org.apache.log4j.Category;

public class Dealer {
    public static boolean slow = false;
    private static Category cat = Category.getInstance(class$com$rexbot$game$card$Dealer == null ? (class$com$rexbot$game$card$Dealer = Dealer.class$("com.rexbot.game.card.Dealer")) : class$com$rexbot$game$card$Dealer);
    private int round = 0;
    private static Shoe shoe = new Shoe(1);
    private int MAX_RAISES_ROUND = 3;
    private Main parent;
    int folders = 0;
    int button = 10;
    static /* synthetic */ Class class$com$rexbot$game$card$Dealer;
    static /* synthetic */ Class class$com$rexbot$game$card$Main;

    private static void newShoe() {
        cat.debug("creating new shoe");
        shoe = new Shoe(1);
    }

    public Dealer(Main parent) {
        this.setParent(parent);
    }

    public void dealHand(boolean practice) {
        History.getInstance().add("START of HAND: " + this.round);
        if (Card.isResetGraphic()) {
            Dealer.newShoe();
        }
        if (!Opts.getInstance().isRegistered() && !RunSimCommand.run && Brain.rand.nextInt(this.round + 1) > 10) {
            try {
                new HelpDialog((Frame)Main.instance, true, (class$com$rexbot$game$card$Main == null ? (class$com$rexbot$game$card$Main = Dealer.class$("com.rexbot.game.card.Main")) : class$com$rexbot$game$card$Main).getResource("/Nag.html")).show();
            }
            catch (Exception ioException) {
                cat.error(ioException, ioException);
            }
        }
        shoe.reset();
        if (practice && this.round % Opts.getInstance().getRoundsPerShuffle() == 0) {
            shoe.shuffle();
        }
        if (!practice) {
            shoe.shuffle();
        }
        Table table = new Table(10, shoe);
        if (RunSimCommand.run) {
            this.getParent().getGameScrollPane().setVisible(false);
            this.getParent().getSimDisplayPanel().setVisible(true);
            this.getParent().getSimDisplayPanel().step();
            Thread.currentThread();
            Thread.yield();
        } else {
            this.getParent().getSimDisplayPanel().setVisible(false);
            this.getParent().getGameScrollPane().setVisible(true);
        }
        this.getParent().getGameScrollPane().setViewportView(table);
        this.findWinner(table);
        table.payWinners();
        table.highLightWinners();
        if (slow) {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (practice && this.round % Opts.getInstance().getRoundsPerMating() == 0) {
            table.mate(-1);
            table.clearAccounts();
        }
        if (!practice && Opts.getInstance().isLearnFromHuman() && this.round % Opts.getInstance().getRoundsPerMating() == 0) {
            table.mate(Opts.getInstance().getHumanPlayer());
            table.clearAccounts();
        }
        History.getInstance().add("END of HAND: " + this.round);
        History.getInstance().dump(Opts.getInstance().getHistoryFile());
        ++this.round;
    }

    private void findWinner(Table table) {
        PlayerManager.getInstance().unfoldPlayers();
        table.highLightFolders();
        table.dealCards(2);
        if (this.checkForWinner(table, true, 2L)) {
            return;
        }
        table.dealCards(3);
        if (this.checkForWinner(table, false, 2L)) {
            return;
        }
        table.dealCards(1);
        if (this.checkForWinner(table, false, 4L)) {
            return;
        }
        table.dealCards(1);
        if (this.checkForWinner(table, false, 4L)) {
            return;
        }
    }

    private boolean checkForWinner(Table table, boolean firstRound, long betSize) {
        if (RunSimCommand.run) {
            this.getParent().getSimDisplayPanel().repaint();
            Thread.currentThread();
            Thread.yield();
        }
        if (slow) {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        PlayerManager.getInstance().resetActivePlayers();
        long bet = 0L;
        int lastToRaise = -1;
        int currentMan = this.button + 1;
        if (currentMan > Opts.getInstance().getNumOfPlayers()) {
            currentMan = 1;
        }
        if (firstRound) {
            ++this.button;
            if (this.button > Opts.getInstance().getNumOfPlayers()) {
                this.button = 1;
            }
            if (Opts.getInstance().getFreezeButtonAt() > 0) {
                this.button = Opts.getInstance().getFreezeButtonAt();
            }
            table.highLightButton(this.button);
            currentMan = this.button + 1;
            if (currentMan > Opts.getInstance().getNumOfPlayers()) {
                currentMan = 1;
            }
            table.highLightCurrentPlayer(currentMan);
            Player player = PlayerManager.getInstance().getPlayer(currentMan);
            player.makeBet(table.getPot(), betSize / 2L);
            player.getHand().setMessage("Raise", Palette.urgentBackgroundColor, Color.black);
            if (++currentMan > Opts.getInstance().getNumOfPlayers()) {
                currentMan = 1;
            }
            table.highLightCurrentPlayer(currentMan);
            player = PlayerManager.getInstance().getPlayer(currentMan);
            player.makeBet(table.getPot(), betSize);
            player.getHand().setMessage("Raise", Palette.urgentBackgroundColor, Color.black);
            bet = 2L;
            if (++currentMan > Opts.getInstance().getNumOfPlayers()) {
                currentMan = 1;
            }
            table.highLightCurrentPlayer(currentMan);
        }
        int raises = 0;
        boolean halted = false;
        block4: do {
            if (slow) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (int i = 0; i < 10; ++i) {
                if (currentMan > Opts.getInstance().getNumOfPlayers()) {
                    currentMan = 1;
                }
                table.highLightCurrentPlayer(currentMan);
                Player player = PlayerManager.getInstance().getPlayer(currentMan);
                if (!player.isFolded()) {
                    int playerPos = this.button - currentMan;
                    if (playerPos < 0) {
                        playerPos = 10 + playerPos;
                    }
                    if (lastToRaise == currentMan) continue block4;
                    long playerBets = player.makeDecision(bet - player.getAmountBetThisRound(), table.getPot().getAmount(), playerPos);
                    if (playerBets == -1L) {
                        History.getInstance().add(player.getName() + " ENDED GAME");
                        halted = true;
                        continue block4;
                    }
                    if (playerBets == 1L || playerBets == 2L && raises >= this.MAX_RAISES_ROUND) {
                        player.makeBet(table.getPot(), bet - player.getAmountBetThisRound());
                        player.getHand().setMessage("Call", Palette.backgroundColor, Color.black);
                        this.callDecision(player.getNumber(), 1L);
                        History.getInstance().add(player.getName() + " called");
                    }
                    if (playerBets == 2L && lastToRaise != currentMan && raises < this.MAX_RAISES_ROUND) {
                        lastToRaise = currentMan;
                        player.getHand().setMessage("Raise", Palette.urgentBackgroundColor, Color.black);
                        History.getInstance().add(player.getName() + " raised");
                        this.callDecision(player.getNumber(), 2L);
                        ++raises;
                        player.makeBet(table.getPot(), (bet += betSize) - player.getAmountBetThisRound());
                    }
                    if (playerBets == 0L) {
                        if (bet > 0L) {
                            if (PlayerManager.getInstance().getActivePlayerCount() > 1) {
                                player.setFolded(true);
                                player.getHand().setMessage("Fold", Palette.passiveBackgroundColor, Color.black);
                                this.callDecision(player.getNumber(), 0L);
                                History.getInstance().add(player.getName() + " folded");
                                ++this.folders;
                            } else {
                                player.makeBet(table.getPot(), bet - player.getAmountBetThisRound());
                                player.getHand().setMessage("Call", Palette.backgroundColor, Color.black);
                                History.getInstance().add(player.getName() + " called");
                                this.callDecision(player.getNumber(), 1L);
                            }
                        } else {
                            player.getHand().setMessage("Call", Palette.backgroundColor, Color.black);
                            History.getInstance().add(player.getName() + " called");
                            this.callDecision(player.getNumber(), 1L);
                        }
                    }
                }
                ++currentMan;
            }
        } while (!halted && PlayerManager.getInstance().getActivePlayerCount() > 1 && !PlayerManager.getInstance().allBetsEqual());
        if (halted) {
            return true;
        }
        table.highLightFolders();
        if (PlayerManager.getInstance().getActivePlayerCount() == 1) {
            return true;
        }
        if (PlayerManager.getInstance().getActivePlayerCount() == 0) {
            throw new RuntimeException("Number of players is ZERO!");
        }
        return false;
    }

    private void callDecision(int player, long decision) {
        if (NewGameCommand.run) {
            StringBuffer sb = new StringBuffer("Player " + player + " ");
            switch ((int)decision) {
                case 0: {
                    sb.append("Folds.");
                    break;
                }
                case 1: {
                    sb.append("Calls.");
                    break;
                }
                case 2: {
                    sb.append("Raises.");
                }
            }
            Main.instance.setInfoText(sb.toString(), Opts.getInstance().getCumputerPlayerDelay() * 1000);
            try {
                Thread.sleep(Opts.getInstance().getCumputerPlayerDelay() * 1000);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    public Main getParent() {
        return this.parent;
    }

    public void setParent(Main parent) {
        this.parent = parent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

