/*
 * Decompiled with CFR 0.152.
 */
package com.rexbot.game.card;

import com.rexbot.game.card.Opts;
import com.rexbot.game.ui.UIService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;

public class GetHumanDecision
extends JDialog
implements ActionListener {
    public static int xpos = Integer.MIN_VALUE;
    public static int ypos = Integer.MIN_VALUE;
    private JButton raiseButton;
    private JLabel betTextLabel;
    private JButton callButton;
    private JButton quitButton;
    private JButton foldButton;
    private int decision;

    public GetHumanDecision(Frame parent, boolean modal, long bet) {
        super(parent, modal);
        this.initComponents();
        this.betTextLabel.setText("Bet To You: $" + bet * (long)Opts.getInstance().getBetMultiplier());
        ((JComponent)this.getContentPane()).registerKeyboardAction(this, "f", KeyStroke.getKeyStroke('f'), 2);
        ((JComponent)this.getContentPane()).registerKeyboardAction(this, "c", KeyStroke.getKeyStroke('c'), 2);
        ((JComponent)this.getContentPane()).registerKeyboardAction(this, "r", KeyStroke.getKeyStroke('r'), 2);
        ((JComponent)this.getContentPane()).registerKeyboardAction(this, "q", KeyStroke.getKeyStroke('q'), 2);
        if (xpos == Integer.MIN_VALUE && ypos == Integer.MIN_VALUE) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension windowSize = this.getSize();
            xpos = (screenSize.width - windowSize.width) / 2;
            ypos = (screenSize.height - windowSize.height) / 2;
        }
        this.setLocation(xpos, ypos);
        this.show();
    }

    private void initComponents() {
        this.betTextLabel = new JLabel();
        this.foldButton = new JButton();
        this.callButton = new JButton();
        this.raiseButton = new JButton();
        this.quitButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GetHumanDecision.this.closeDialog(evt);
            }
        });
        this.betTextLabel.setText("Bet to you: ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        this.getContentPane().add((Component)this.betTextLabel, gridBagConstraints);
        this.foldButton.setMnemonic('f');
        this.foldButton.setText("Fold");
        this.foldButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetHumanDecision.this.foldButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.foldButton, gridBagConstraints);
        this.callButton.setMnemonic('c');
        this.callButton.setText("Call");
        this.callButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetHumanDecision.this.callButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.callButton, gridBagConstraints);
        this.raiseButton.setMnemonic('r');
        this.raiseButton.setText("Raise");
        this.raiseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetHumanDecision.this.raiseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.raiseButton, gridBagConstraints);
        this.quitButton.setMnemonic('q');
        this.quitButton.setText("Quit");
        this.quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetHumanDecision.this.quitButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.quitButton, gridBagConstraints);
        this.pack();
    }

    private void quitButtonActionPerformed(ActionEvent evt) {
        UIService.getInstance().fire("StopGame", null);
        this.setDecision(-1);
        this.closeDialog(null);
    }

    private void raiseButtonActionPerformed(ActionEvent evt) {
        this.setDecision(2);
        this.closeDialog(null);
    }

    private void callButtonActionPerformed(ActionEvent evt) {
        this.setDecision(1);
        this.closeDialog(null);
    }

    private void foldButtonActionPerformed(ActionEvent evt) {
        this.setDecision(0);
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        xpos = this.getLocation().x;
        ypos = this.getLocation().y;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        System.out.println("Got: " + new GetHumanDecision(null, true, 5L).getDecision());
    }

    public int getDecision() {
        return this.decision;
    }

    public void setDecision(int decision) {
        this.decision = decision;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("f")) {
            this.setDecision(0);
            this.closeDialog(null);
        } else if (actionEvent.getActionCommand().equals("c")) {
            this.setDecision(1);
            this.closeDialog(null);
        } else if (actionEvent.getActionCommand().equals("r")) {
            this.setDecision(2);
            this.closeDialog(null);
        } else if (actionEvent.getActionCommand().equals("q")) {
            UIService.getInstance().fire("StopGame", null);
            this.setDecision(-1);
            this.closeDialog(null);
        }
    }
}

