Attribute VB_Name = "modElemMaker"
Type ElementEntryVars
    Invisible As Boolean
    Symbol As Variant
    ForeColor As Long
    BackColor As Long
    QuickInfo As String
    NoData As Boolean
    Data(1 To 8) As String
End Type

Type TopicEntryVars
    Author As String
    Date As String
    Locked As Boolean
    Password As String
End Type

Public Const Header = "EMFv1.0-File to be read by Element Maker v1.0"
Public Const Version = "Element Maker v1.0"
Public Const EmEntries = 1
Public Const EmData = 2
Public Const EmByLine = 3
Public Const EmDescription = 4
Public Const EmTable = 5
Public Const EmNoError = 0
Public Const EmError = 1

Public ElementEntry(216) As ElementEntryVars
Public TopicEntry As TopicEntryVars
Public DummyTopicEntry As TopicEntryVars
Public CurrentSelected As Integer
Public CurrentFileName As Variant
Public Titled As Boolean

Sub ClearItUp()
    For Iodine = 1 To 216
        ElementEntry(Iodine).Invisible = False
        ElementEntry(Iodine).Symbol = ""
        ElementEntry(Iodine).BackColor = &HC0C0C0
        ElementEntry(Iodine).ForeColor = &H8
        ElementEntry(Iodine).QuickInfo = ""
        ElementEntry(Iodine).NoData = False
        ElementEntry(Iodine).QuickInfo = ""
        ElementEntry(Iodine).Data(1) = ""
        ElementEntry(Iodine).Data(2) = ""
        ElementEntry(Iodine).Data(3) = ""
        ElementEntry(Iodine).Data(4) = ""
        ElementEntry(Iodine).Data(5) = ""
        ElementEntry(Iodine).Data(6) = ""
        ElementEntry(Iodine).Data(7) = ""
        ElementEntry(Iodine).Data(8) = ""
    Next Iodine
    LoadDataTofrmTable
    TopicEntry.Author = ""
    TopicEntry.Date = ""
    TopicEntry.Locked = False
    TopicEntry.Password = ""
    SomebodyClickedMe 1
End Sub

Public Function Dec(HexExp$)
    Decimal = 0
    For RightNow = 1 To Len(HexExp$)
        Factor = 16 ^ (Len(HexExp$) - RightNow)
        Select Case Mid$(HexExp$, RightNow, 1)
            Case "0": NowDec = 0
            Case "1": NowDec = 1
            Case "2": NowDec = 2
            Case "3": NowDec = 3
            Case "4": NowDec = 4
            Case "5": NowDec = 5
            Case "6": NowDec = 6
            Case "7": NowDec = 7
            Case "8": NowDec = 8
            Case "9": NowDec = 9
            Case "A": NowDec = 10
            Case "B": NowDec = 11
            Case "C": NowDec = 12
            Case "D": NowDec = 13
            Case "E": NowDec = 14
            Case "F": NowDec = 15
        End Select
        Decimal = NowDec * Factor + Decimal
    Next RightNow
    Dec = Decimal
End Function
Public Sub LoadDataTofrmTable()
    For Iodine = 1 To 216
        frmTable!Elements(Iodine).Caption = ElementEntry(Iodine).Symbol
        frmTable!Elements(Iodine).BackColor = ElementEntry(Iodine).BackColor
        frmTable!Elements(Iodine).ForeColor = ElementEntry(Iodine).ForeColor
    Next Iodine
End Sub

Public Sub NewFile()
    Response = MsgBox("Save changes to current file?", vbExclamation + vbYesNoCancel, "Element Maker")
    Select Case Response
        Case vbCancel
            Exit Sub
        Case vbYes
            If SaveFile = EmError Then Exit Sub
    End Select
    CurrentFileName = "untitled.emf"
    frmToolBox!CommonDialog.FileName = CurrentFileName
    Titled = False
    ClearItUp
End Sub


Public Sub OpenFile()
    Response = MsgBox("Save changes to current file?", vbExclamation + vbYesNoCancel, "Element Maker")
    Select Case Response
        Case vbCancel
            Exit Sub
        Case vbYes
            If SaveFile = EmError Then Exit Sub
    End Select
    On Error GoTo ErrHandler
    frmToolBox!CommonDialog.ShowOpen
    CurrentFileName = frmToolBox!CommonDialog.FileName
    Titled = True
    OpenToFile CurrentFileName
    Exit Sub

ErrHandler:
    Exit Sub
End Sub
Public Sub OpenToFile(FileName As Variant)

    SetAttr FileName, vbArchive
    Free = FreeFile
       
    Open FileName For Random As #Free Len = 3 + 216
        On Error GoTo ErrHandler
        Get #Free, 1, PutHeader
        If PutHeader <> Header$ Then
            MsgBox "This file does not have the EMFv1.0 header", 48, Version
            Close #Free
            Exit Sub
        End If
        
        Get #Free, , DummyTopicEntry
        If DummyTopicEntry.Locked Then
            CoolPassword$ = InputBox("This EMF file is protected.  Please enter the password:", "Element Maker", "<Password>")
            If CoolPassword$ <> DummyTopicEntry.Password Then
                MsgBox "Element Maker could not open this file because the entered password was wrong.", vbOKOnly, "Element Maker"
                Close #Free
                Exit Sub
            End If
        End If
        Get #Free, , TopicEntry
        For Iodine = 1 To 216
            Get #Free, , ElementEntry(Iodine)
        Next Iodine
        LoadDataTofrmTable
        SomebodyClickedMe 1
       
    Close #Free
'    ResizeAll
    Exit Sub
    
ErrHandler:
    MsgBox "This file does not have the EMFv1.0 format", 48, Version
    Close #Free
End Sub
Public Sub RecordAll()
    For WhatToResize = 1 To 5 Step 1
        RecordResize WhatToResize
    Next WhatToResize
End Sub

Public Sub RecordResize(WhatResize)
    
    Select Case WhatResize
        
        Case EmTable:
'            SizeVars(EmTable).Top = frmTable.Top
'            SizeVars(EmTable).Left = frmTable.Left
'            SizeVars(EmTable).Height = frmTable.Height
'            SizeVars(EmTable).Width = frmTable.Width
            
        Case EmDescription:
'            SizeVars(EmDescription).Top = frmDescription.Top
'            SizeVars(EmDescription).Left = frmDescription.Left
'            SizeVars(EmDescription).Height = frmDescription.Height
'            SizeVars(EmDescription).Width = frmDescription.Width
            
        Case EmEntries:
'            SizeVars(EmEntries).Top = frmDescription!EntryBox.Top
'            SizeVars(EmEntries).Left = frmDescription!EntryBox.Left
'            SizeVars(EmEntries).Height = frmDescription!EntryBox.Height
'            SizeVars(EmEntries).Width = frmDescription!EntryBox.Width
    
        Case EmData:
'            SizeVars(EmData).Top = frmDescription!DataBox.Top
'            SizeVars(EmData).Left = frmDescription!DataBox.Left
 '           SizeVars(EmData).Height = frmDescription!DataBox.Height
 '           SizeVars(EmData).Width = frmDescription!DataBox.Width
        
        Case EmByLine:
 '           SizeVars(EmByLine).Top = frmDescription!ByLine.Top
 '           SizeVars(EmByLine).Left = frmDescription!ByLine.Left
 '           SizeVars(EmByLine).Height = frmDescription!ByLine.Height
 '           SizeVars(EmByLine).Width = frmDescription!ByLine.Width
            
    End Select

End Sub

Public Sub ResizeAll()

    ResizeThing EmTable
    ResizeThing EmDescription
    ResizeThing EmEntries
    ResizeThing EmData
    ResizeThing EmByLine
    
End Sub

Public Sub ResizeThing(WhatResize)
    
    Select Case WhatResize
        
        Case EmTable:
'            frmTable.Top = SizeVars(EmTable).Top
'            frmTable.Left = SizeVars(EmTable).Left
'            frmTable.Height = SizeVars(EmTable).Height
'            frmTable.Width = SizeVars(EmTable).Width
            
        Case EmDescription:
'            frmDescription.Top = SizeVars(EmDescription).Top
'            frmDescription.Left = SizeVars(EmDescription).Left
'            frmDescription.Height = SizeVars(EmDescription).Height
'            frmDescription.Width = SizeVars(EmDescription).Width
            
        Case EmEntries:
'            frmDescription!EntryBox.Top = SizeVars(EmEntries).Top
'            frmDescription!EntryBox.Left = SizeVars(EmEntries).Left
'            frmDescription!EntryBox.Height = SizeVars(EmEntries).Height
'            frmDescription!EntryBox.Width = SizeVars(EmEntries).Width
    
        Case EmData:
'            frmDescription!DataBox.Top = SizeVars(EmData).Top
'            frmDescription!DataBox.Left = SizeVars(EmData).Left
'            frmDescription!DataBox.Height = SizeVars(EmData).Height
'            frmDescription!DataBox.Width = SizeVars(EmData).Width
        
        Case EmByLine:
'            frmDescription!ByLine.Top = SizeVars(EmByLine).Top
'            frmDescription!ByLine.Left = SizeVars(EmByLine).Left
'            frmDescription!ByLine.Height = SizeVars(EmByLine).Height
'            frmDescription!ByLine.Width = SizeVars(EmByLine).Width
            
    End Select

End Sub
Public Function SaveAsFile()
    On Error GoTo ErrHandler

Restart:
    frmToolBox!CommonDialog.ShowSave
    If Dir(frmToolBox!CommonDialog.FileName) <> "" Then
        If MsgBox("Overwrite existing file?", vbExclamation + vbYesNo, "Element Maker") = vbNo Then GoTo Restart
    End If
    CurrentFileName = frmToolBox!CommonDialog.FileName
    SaveToFile CurrentFileName
    Titled = True
    SaveAsFile = EmNoError
    Exit Function

ErrHandler:
    SaveAsFile = EmError
    Exit Function
End Function
Public Sub ExitAll()
    Response = MsgBox("Save changes to current file?", vbExclamation + vbYesNo, "Element Maker")
    Select Case Response
        Case vbCancel
            Load frmToolBox
            frmToolBox.Show
            Exit Sub
        Case vbYes
            If SaveFile = EmError Then
'                Load frmToolBox
'                frmToolBox.Show
'                Exit Sub
                End
            End If
    End Select
    Unload frmTable
    Unload frmToolBox
    Unload frmDescription
    Unload frmProperties
    End
End Sub
Public Function SaveFile()
    If Titled = True Then
        SaveToFile CurrentFileName
        SaveFile = EmNoError
    Else
        SaveFile = SaveAsFile
    End If
End Function

Public Sub SaveToFile(FileName As Variant)

    Free = FreeFile
    
    If Dir(FileName) <> "" Then
        Kill FileName
    End If
    
    Open FileName For Random Shared As #Free Len = 3 + 216
        PutHeader = Header$
        Put #Free, 1, PutHeader
        Put #Free, , TopicEntry
        Put #Free, , TopicEntry
        For Iodine = 1 To 216
            Put #Free, , ElementEntry(Iodine)
        Next Iodine
    Close #Free
   
End Sub

    
    

Public Sub SomebodyClickedMe(Selected)
    
    CurrentSelected = Selected
    For Iodine = 1 To 8
        If ElementEntry(CurrentSelected).Data(Iodine) <> "" Then
            frmProperties!txtElementEntry(Iodine).Text = ElementEntry(CurrentSelected).Data(Iodine)
        Else
            frmProperties!txtElementEntry(Iodine).Text = frmProperties!txtElementEntry(Iodine).Tag
        End If
        frmDescription!lblDataTopic(Iodine).Caption = frmDescription!txtElementEntry(Iodine).Tag + " :"
        frmDescription!txtElementEntry(Iodine).Text = frmProperties!txtElementEntry(Iodine).Text
    Next Iodine
    
    If TopicEntry.Author = "" Then TopicEntry.Author = "Your name"
    If TopicEntry.Date = "" Then TopicEntry.Date = "date"
    
    frmDescription!txtByLine.Text = "Made by " + TopicEntry.Author + " on " + TopicEntry.Date

    frmProperties!txtBackground.Text = Right("000000" + Hex(ElementEntry(Selected).BackColor), 6)
    frmProperties!txtForeground.Text = Right("000000" + Hex(ElementEntry(Selected).ForeColor), 6)
    frmProperties!lblElementID.Caption = "Element Maker - Element ID #" + Str(Selected)
    frmTable!lblQuickInfo.Caption = ElementEntry(CurrentSelected).QuickInfo
    frmProperties!txtQuickInfo.Text = ElementEntry(CurrentSelected).QuickInfo
    frmProperties!txtSymbol.Text = ElementEntry(CurrentSelected).Symbol
    
    If TopicEntry.Password <> "" Then
        frmProperties!txtPassword.Text = TopicEntry.Password
    End If
    frmProperties!txtName.Text = TopicEntry.Author
    frmProperties!txtDate.Text = TopicEntry.Date
    
    If ElementEntry(CurrentSelected).NoData Then
        frmProperties!chkElement.Value = 0
    Else
        frmProperties!chkElement.Value = 1
    End If
    
    If TopicEntry.Locked Then
        frmProperties!chkProtected.Value = 1
    Else
        frmProperties!chkProtected.Value = 0
    End If
    
    If ElementEntry(CurrentSelected).Invisible = True Then
        frmProperties!chkVisible.Value = 0
    Else
        frmProperties!chkVisible.Value = 1
    End If

End Sub
