// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: cdate.h 
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/21/1997 
// Date Last Modified: 06/27/2001
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The CDate class is used turn a date string into into concrete
data type.
*/
// ----------------------------------------------------------- //   
#ifndef __GX_CDATE_HPP__
#define __GX_CDATE_HPP__

// Define this macro to use the CPP iostream
// #ifndef __USE_CPP_IOSTREAM__
// #define __USE_CPP_IOSTREAM__
// #endif

#include <iostream.h>
#include "gxdtypes.h"
#include "gxuint16.h"

// (C)oncrete (D)ate class
class CDate
{
public:
  CDate() { }
  CDate(__UBYTE__ month, __UBYTE__ day, gxUINT16 year) {
    Month = month, Day = day, Year = year;
  }
  CDate(const CDate& ob);
  CDate& operator=(const CDate& ob);
  
public:
  void SetDay(__UBYTE__ byte) { Day = byte; }
  void SetMonth(__UBYTE__ byte) { Month = byte; }
  void SetYear(gxUINT16 uint16) { Year = uint16; }
  void SetDate(__UBYTE__ month, __UBYTE__ day, gxUINT16 year) {
    Month = month, Day = day, Year = year;
  }
  __UBYTE__ GetDay() { return Day; }
  __UBYTE__ GetMonth() { return Month; }
  gxUINT16 GetYear() { return Year; }
  char *c_str();
  char *month_c_str();
  char *day_c_str();
  char *year_c_str();
  unsigned SizeOf() { return sizeof(Month)+sizeof(Day)+sizeof(Year); }
  
public: // Overloaded operators
  friend int operator==(const CDate &a, const CDate &b);
  friend int operator!=(const CDate &a, const CDate &b);
  friend int operator<(const CDate &a, const CDate &b);
  friend int operator>(const CDate &a, const CDate &b);

public:
#ifdef __USE_CPP_IOSTREAM__
  friend ostream &operator<<(ostream &os, const CDate &ob);
  friend void operator>>(istream &is, CDate &ob);
#endif
  
private:
  __UBYTE__ Month;
  __UBYTE__ Day;
  gxUINT16 Year;
};

#endif  // __GX_CDATE_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
