// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: dbasekey.h 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 08/22/2000 
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The DatabaseKeyB base class is an abstract base class used define
database key types and the methods by which database keys are
sorted.  
*/
// ----------------------------------------------------------- //   
#ifndef __GX_DATABASE_KEY_HPP__
#define __GX_DATABASE_KEY_HPP__

#include "keytypes.h"

class DatabaseKeyB
{
public:
  DatabaseKeyB(void *kptr);
  virtual ~DatabaseKeyB();

protected:
  DatabaseKeyB(const DatabaseKeyB &ob) {
    db_key = ob.db_key;
    right_child = ob.right_child;
  }
  DatabaseKeyB& operator=(const DatabaseKeyB &ob) { 
    db_key = ob.db_key;
    right_child = ob.right_child;
    return *this; 
  }

public:
  size_t SizeOfDatabaseKey() { return KeySize() + sizeof(right_child); }
    
public: // Derived class interface
  virtual size_t KeySize() = 0;
  virtual int operator==(const DatabaseKeyB& key) const = 0;
  virtual int operator>(const DatabaseKeyB& key)  const = 0;

public: // Persistent data members
  FAU right_child; // File pointer to the right child
  void *db_key;    // Memory Pointer to the database entry key
};

#endif // __GX_DATABASE_KEY_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
