// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: asprint.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/18/1997  
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

These classes and functions are used to print data to ASCII
text files and format data for various print functions.
*/
// ----------------------------------------------------------- // 
#ifndef __GX_ASPRINT_HPP__
#define __GX_ASPRINT_HPP__

#include <fstream.h> 

// Constants for print functions
const int asPrintCols = 80;      // Columns for portrait print outs
const int asPrintColsLong = 132; // Columns for landscape print outs
const int asPrintRows = 25;      // Rows for portrait print outs
const int asPrintRowsLong = 25;  // Rows for landscape print outs

// Control characters
const char asLineFeed = '\n';

// Function prototypes for standalone print functions
void ASPrint(const char *s, ostream &stream, int offset, int pos = 0,
	     const char pad = ' ');
void ASPrint(const char *s, const char filter, ostream &stream, int offset,
	     int pos = 0, const char pad = ' ');
void ASPrint(const char c, ostream &stream, int offset, int pos = 0,
	     const char pad = ' ');
void ASPrint(int val, ostream &stream, int offset, int pos = 0,
	     const char pad = ' ');
void ASPrint(long val, ostream &stream, int offset, int pos = 0,
	     const char pad = ' ');
void ASPrint(double val, ostream &stream, int offset, int pos = 0,
	     const char pad = ' ');

#endif // __GX_ASPRINT_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
