// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: eds201.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 04/30/2001
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Code used to generate platform independent encrypted data sets
used in cross-platform communication applications.
*/
// ----------------------------------------------------------- // 
#ifndef __GX_EDS201_HPP__
#define __GX_EDS201_HPP__

#include "gxuint16.h"

// ---------------------------------------------------------------------
// Global and type defines constants for EDS version 2 data sets 
// ---------------------------------------------------------------------
typedef gxUINT16 eds2WORD;     // Data type used for encrypted characters
typedef __USWORD__ eds2WORD_t; // Native type used for encrypted characters
typedef __USWORD__ eds2MagicNumber_t;            // Magic number native type 
const eds2MagicNumber_t eds2MagicNumber = 34881; // Default magic number
const unsigned eds2TableSize = 256;              // Size of EDS tables
const unsigned eds2MaxLine = 255;                // Max chars per line
const eds2WORD eds2EOT = (gxUINT16)0x0000;       // End of text marker
const double eds2VersionNumber = 4000.101;       // Current version number

// Class used to read and write encrypted data sets strings
class eds2String
{
public:
  eds2String(eds2MagicNumber_t magic_num = eds2MagicNumber);
  ~eds2String() { }
  eds2String(const eds2String &ob);
  eds2String operator=(const eds2String &ob);
  
public:
  void InitDynamicTable(eds2MagicNumber_t magic_num = eds2MagicNumber);
  eds2WORD EncryptString(unsigned char c);
  int DecryptString(eds2WORD val, unsigned char &c);
  void eds2Copy(const eds2String &ob);
  
public:
  eds2WORD eds2_magic_number; // EDS2 magic number use to encrypt strings  
  eds2WORD eds2_table[eds2TableSize]; // EDS2 Dynamic table
};

#endif // __GX_EDS201_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
