// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: futils.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 01/25/2000
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

General-purpose platform independent file and directory functions
that need to be ported between WIN32 and UNIX platforms. 
*/
// ----------------------------------------------------------- // 
#ifndef __GX_FILE_UTILITIES_HPP__
#define __GX_FILE_UTILITIES_HPP__

/* Non-platform specific include files */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

// Platform specific include files 
#if defined (__WIN32__)
// WIN32 include files for file/directory functions 
#include <windows.h>
#include <direct.h>
#include <io.h>
#include <share.h>

#elif defined (__UNIX__)
// UNIX include files for file/directory functions for all
// UNIX variants. NOTE: Place specific UNIX variants above
// this directive.
#include <unistd.h> // UNIX standard function definitions
#include <dirent.h> // POSIX directory stream fucntions 
#else
#error You must define a target platform: __WIN32__ or __UNIX__
#endif

// Platform independent path and directory length definitions 
const unsigned futils_MAX_LINE_LENGTH = 1024; // Max line length
const unsigned futils_MAX_NAME_LENGTH = 255;  // Max length of a file name
const unsigned futils_MAX_DIR_LENGTH  = 1024; // Max length of a directory name
const unsigned futils_MAX_PATH_LENGTH = 1024; // Max absolute or relative path 

// Enumerations 
typedef enum { 
  // Permission mode enumeration needed to set file permissions
  // when new files are created. 
  futils_READONLY,
  futils_WRITEONLY,
  futils_READWRITE
} futilPermissionMode;

// ---------------------------------------------------------- //
// POSIX Directory stream and directory entry data structures //
// ---------------------------------------------------------- //
#if defined (__WIN32__)
// POSIX style directory entry for WIN32 platforms
typedef struct dirent {
  HANDLE d_ino;   // File number of entry 
  DWORD d_reclen; // Length of this record 
  DWORD d_namlen; // Length of string in d_name 
  char  d_name[futils_MAX_NAME_LENGTH]; // Name of this file 

  // WIN32 Specifics 
  WIN32_FIND_DATA file; // Describes a file found by a WIN32 find function 
} WIN32FileData;

// POSIX style directory structure for WIN32 platforms 
typedef struct {
  int dd_fd;            // optional file descriptor 
  DWORD dd_loc;         // file location in the directory stream 
  DWORD dd_size;        // file size  
  WIN32FileData dd_buf; // WIN32 file information 
  char dd_dirname[futils_MAX_NAME_LENGTH]; // Directory name 
} DIR;
#endif

// ----------------------------------------------------------- //
// Standalone platform indepentent file/directory functions    //
// ----------------------------------------------------------- //
int futils_exists(const char *name);
int futils_isdirectory(const char *dir_name);
int futils_isfile(const char *fname);
void futils_makeDOSpath(char *path);
void futils_makeUNIXpath(char *path);
int futils_chdir(const char *dir_name);
int futils_rmdir(const char *dir_name);
int futils_hasdriveletter(const char *dir_name, char *letter);
int futils_mkdir(const char *dir_name);
int futils_remove(const char *fname);
int futils_rename(const char *oldname, const char *newname);
int futils_chmod(const char *fname, futilPermissionMode pmode);
void futils_pathsimplify(const char *path, char *new_path, char path_sep);
int futils_genoutputfilename(const char *current_file, char *out_file,
			    char *extension);
int futils_getcwd(char *dir, unsigned max_len);
long futils_filelength(int fd);
// ----------------------------------------------------------- //

// ----------------------------------------------------------- //
// Standalone platform indepentent directory stream functions  //
// ----------------------------------------------------------- //
DIR *futils_opendir(const char *dirname);
int futils_closedir(DIR *dirp);
struct dirent *futils_readdir(DIR *dirp);
void futils_rewinddir(DIR *dirp);
// ----------------------------------------------------------- //

#endif // __GX_FILE_UTILITIES_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //


