// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: gxdbase.h 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/04/1997 
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The gxDatabase engine is a low-level file handler used to 
manipulate contiguous blocks of binary data. Low-level methods 
include read, write, and seek operations, create and open functions, 
linear navigation, and large file support. Optional methods include 
CRC checking, file and node locking.
*/
// ----------------------------------------------------------- //  
#ifndef __GX_DATABASE_HPP__
#define __GX_DATABASE_HPP__

#include "gxdfptr.h"
#include "gxcrc32.h"
#include "gxderror.h"

class gxDatabase
{
public:
  gxDatabase();
  virtual ~gxDatabase();

private:
  // Disallow copying and assignment to prevent multiple copies of
  // database objects. Forcing pointer semantics to helps to ensure
  // the safe deletion or modification of a database object.
  gxDatabase(const gxDatabase &ob) { }
  void operator=(const gxDatabase &ob) { }

public: // Database functions
  virtual gxDatabaseError Create(const char *fname, FAU static_size = (FAU_t)0,
			 __SBYTE__ RevisionLetter = gxDatabaseRevisionLetter);
  virtual gxDatabaseError Open(const char *fname, 
			       gxDatabaseAccessMode mode = gxDBASE_READWRITE);
  virtual gxDatabaseError Close();
  virtual gxDatabaseError Flush();
  gxDatabaseError Read(void *buf, __ULWORD__ bytes, 
		       FAU file_address = gxCurrAddress);
  gxDatabaseError Write(const void *buf, __ULWORD__ bytes, 
			FAU file_address = gxCurrAddress,
			int flush = 1, int bit_test = 1);
  gxDatabaseError Seek(FAU offset, gxDatabaseSeekMode mode = gxDBASE_SEEK_BEG);
  FAU SeekTo(FAU file_address);
  gxStreamPos FilePosition();
  
public: // Allocation/Deallocation functions
  virtual FAU Alloc(__ULWORD__ bytes,
		    gxDatabaseReclaimMethod method = gxDBASE_RECLAIM_FIRSTFIT);
  FAU ReclaimBestFit(__ULWORD__ bytes);
  FAU ReclaimFirstFit(__ULWORD__ bytes);
  int Delete(FAU object_address, int remove = 0); 
  int Remove(FAU object_address);
  int UnDelete(FAU object_address);

protected: // Internal processing fucntions
  gxDatabaseError InitFileHdr();
  
public: // Functions used to calculate file offsets
  size_t FileHeaderSize() const;
  size_t FileHeaderSize(); 
  size_t BlockHeaderSize() const;
  size_t BlockHeaderSize();
  __ULWORD__ ObjectLength(FAU object_address = gxCurrAddress);
  __ULWORD__ BlockLength(FAU object_address = gxCurrAddress);

public:  // File Status functions
  int IsOK() { return ((is_ok == 1) && (is_open == 1)); }
  int IsOK() const { return ((is_ok == 1) && (is_open == 1)); }
  int IsOpen() { return ((is_ok == 1) && (is_open == 1)); }
  int IsOpen() const { return ((is_ok == 1) && (is_open == 1)); }
  int ReadForReading() const { return ready_for_reading == 1; }
  int ReadForReading() { return ready_for_reading == 1; }
  int ReadyForWriting() const { return ready_for_writing == 1; }
  int ReadyForWriting() { return ready_for_writing == 1; }

public: // File and block header functions
  gxDatabaseError ReadFileHdr();
  gxDatabaseError WriteFileHdr();
  gxDatabaseError ReadBlockHdr(gxBlockHeader &hdr, 
			       FAU block_address = gxCurrAddress);
  gxDatabaseError WriteBlockHdr(const gxBlockHeader &hdr, 
				FAU block_address = gxCurrAddress);

public:  // Exception handling functions
  gxDatabaseError GetDatabaseError() { return gxd_error; }
  gxDatabaseError GetDatabaseError() const { return gxd_error; }
  gxDatabaseError SetDatabaseError(gxDatabaseError err) {
    return gxd_error = err;
  }
  gxDatabaseError ResetDatabaseError() { return gxd_error = gxDBASE_NO_ERROR; }
  const char *DatabaseExceptionMessage();

public: // Static file statistics
  const char *GetSignature() const;
  char *GetSignature();
  char GetRevLetter() { return rev_letter; }
  const char GetRevLetter() const { return rev_letter; }
  FAU GetVersion() const { return file_header.gxd_ver; }
  FAU GetVersion() { return file_header.gxd_ver; }
  const char *DatabaseName() const { return (const char *)file_name; }
  char *DatabaseName() { return file_name; }
  FAU StaticArea();
    
public: // Dynamic file statistics
  FAU GetDatabaseFreeSpace();
  FAU GetEOF();
  FAU GetHeapStart();
  FAU GetHighestBlock();
  int TestFileHeader(); // Keeps database file header's dynamic data in sync
  FAU TotalBlocks();    // Return total number of Blocks
  FAU DeleteBlocks(FAU *d = 0, FAU *r = 0);
  
public: // Linear navigation methods
  FAU FindFirstBlock(FAU offset = (FAU_t)0); // Finds first valid Block
  FAU FindPrevBlock(FAU offset);             // Finds the previous block 
  FAU FindNextBlock(FAU offset = (FAU_t)0);  // Finds next after first 
  FAU FindFirstObject(FAU offset = (FAU_t)0); // Finds first object address
  FAU FindPrevObject(FAU offset);             // Finds the previous object 
  FAU FindNextObject(FAU offset = (FAU_t)0);  // Finds next object after first 
  
public: // General purpose file utilities
  static int Exists(const char *fname);
  static FAU FileSize(const char *fname);
  
public: // Revision letter functions
  void SetRevisionLetter(__SBYTE__ RevisionLetter);

public: // 32-bit CRC checksum routines (revision A and higher)
  __ULWORD__ CalcChecksum(__ULWORD__ bytes, FAU file_address, 
			  int mem_alloc = 1);
  gxUINT32 WriteObjectChecksum(FAU object_address);
  int ReadObjectChecksum(FAU object_address, __ULWORD__ *object_crc = 0,
			 __ULWORD__ *calc_crc = 0);

public: // File lock functions (revision B and higher)
  void InitFileLockHdr(gxFileLockHeader &hdr);
  gxDatabaseError ResetFileLock();
  gxDatabaseError WriteFileLockHdr(const gxFileLockHeader &hdr);
  gxDatabaseError ReadFileLockHdr(gxFileLockHeader &hdr);
  int LockFile(gxDatabaseLockType l_type = gxDBASE_WRITELOCK);
  int UnlockFile(gxDatabaseLockType l_type = gxDBASE_WRITELOCK);

public: // Record lock functions (revision C and higher)
  void InitRecordLockHdr(gxRecordLockHeader &hdr);
  gxDatabaseError ResetRecordLock(FAU block_address = gxCurrAddress);
  gxDatabaseError ReadRecordLockHdr(gxRecordLockHeader &hdr, 
				    FAU block_address = gxCurrAddress);
  gxDatabaseError WriteRecordLockHdr(const gxRecordLockHeader &hdr, 
				     FAU block_address = gxCurrAddress);
  int LockRecord(gxDatabaseLockType l_type = gxDBASE_WRITELOCK,
		 FAU block_address = gxCurrAddress);
  int UnlockRecord(gxDatabaseLockType l_type = gxDBASE_WRITELOCK,
		   FAU block_address = gxCurrAddress);

protected:
  char file_name[gxMaxNameLength];    // Open database file name
  char rev_letter;                    // Database revision letter
  gxFileHeader file_header;           // Database file header
  gxdFPTR *fp;                        // Stream file handle
  gxDatabaseOperation last_operation; // Last I/O operation preformed
  gxDatabaseError gxd_error;          // Last reported file error

  // File status members
  int is_ok;             // Used to signal a fatal error condition
  int is_open;           // True if the file is open
  int ready_for_reading; // True if the file is ready for reading
  int ready_for_writing; // True if the file is ready for writing

public: // Static data members used in place of global variables
  static __SBYTE__ gxSignature[gxSignatureSize]; // Signature for datbase files
  static FAU gxVersion;                // Version number database files
  static gxUINT32 gxInternalCheckWord; // Synchronization word

public: // Overloaded operators
  int operator!() const { return ((is_ok == 0) || (is_open == 0)); }
  int operator!() { return ((is_ok == 0) || (is_open == 0)); }
  operator const int () const { return ((is_ok == 1) && (is_open == 1)); }
  operator int () { return ((is_ok == 1) && (is_open == 1)); }
};

#endif // __GX_DATABASE_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
