// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: httpgrab.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 01/25/2000
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The HTTPGrab class is used to grab specifed documents from an
HTTP server. 
*/
// ----------------------------------------------------------- // 
#ifndef __GX_HTTPGRAB_HPP__
#define __GX_HTTPGRAB_HPP__

#include "gxshttp.h"
#include "gxshttpc.h"
#include "gxshtml.h"
#include "gxsurl.h"
#include "gxlist.h"

struct urlQueueNode {
  urlQueueNode();
  ~urlQueueNode() { }
  urlQueueNode(const urlQueueNode &ob) { Copy(ob); }
  urlQueueNode& operator=(const urlQueueNode &ob) { Copy(ob); return *this; }
  void Copy(const urlQueueNode &ob);

  // Overloaded operators
  friend int operator==(const urlQueueNode &a, const urlQueueNode &b);
  
  gxsURLInfo u; // Uniform resource locator
  gxString url_parent_directory; // This URL's parent directory
};

class HTTPGrab : public gxsHTML
{
public:
  HTTPGrab();
  ~HTTPGrab();

public: 
  int SetWebAddress(const gxString &web_url);
  int GrabHTMLFile(gxsURLInfo &u);
  int GrabHTMLFile(gxsURLInfo &u, fstream *outfile);
  int GrabHTMLFile(gxsURLInfo &u, MemoryBuffer &mbuf);
  char *GetDefaultIndexFileName();
  const char *GetDefaultIndexFileName() const;
  void WorkOffLine() { work_offline = 1; }
  void WorkOnLine() { work_offline = 0; }
  
private: // Tag handlers
  void Handle_A_Tag();     // Anchor tag handler
  void Handle_BODY_Tag();  // Body tag handler
  void Handle_IMG_Tag();   // Inline Image tag handler
  void Handle_AREA_Tag();  // Area tag handler
  void Handle_FRAME_Tag(); // Frame tag handler

private:
  int LoadURL(const gxString &attr);
  int CleanTagInfo(gxString &tag, const char *attrib);
  
public:
  gxsHTTPClient client;
  gxsHTTPHeader hdr;
  gxList<urlQueueNode> files_to_download; // Queue of files to download
  gxList<gxString> files_downloaded;      // List of files downloaded
  gxString top_level_directory;
  gxString url_parent_directory;
  
private:
  gxsURL url;
  unsigned bytes_received;
  gxString server_name;
  
  // Username and password used to every document in this realm
  gxString username;
  gxString password;
  
private:
  // True if working offline with previously downloaded websites
  int work_offline; 
};

// Functions used for test purposes only
void hgPrintURLInfo(const gxsURLInfo &u);
void hgPringHTTPHeader(const gxsHTTPHeader &hdr);
void hgPrintNumBytesReceived(int bytes);
void hgPrintConnectionMessage1(const gxsURLInfo &u);
void hgPrintConnectionMessage2(const gxsURLInfo &u);
void hgPrintDownloadCompleteMessage();

#endif // __GX_HTTPGRAB_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
