// Custom Tree
// Date Started: 25/09/2002
// Copyright (C) Speciality Applications 2002.
// All rights reserved. This program is protected by 
// Australian and International copyright laws. 

// Revision Note 

// Start Tree Code
function CTree()
{
	this.Root = new CFolder("Root", "");
	return this.Root;
}

function CFolder(aCaption, aIcon)
{
	this.Index = 0;
	this.Type = "Folder";
	this.Caption = aCaption;
	this.Icon = aIcon;
	this.Child = new Array;
	this.ChildCount = 0;
	this.Expand = false;
	this.HTMLExpand = "";
	this.HTMLCollapse = "";
	this.Level = 0;
	this.isLastNode = false;

	this.AddChild = AddChild;
	this.Initialise = InitialiseFolder;
	this.CreateNode = CreateNode;
	this.Collapse = CollapseFolder;
}

function AddChild(ANode)
{
	this.Child[this.ChildCount] = ANode; 
  this.ChildCount++; 
  return ANode; 
}

function InitialiseFolder(aLevel, aLastNode)
{
	this.CreateNode();
	this.Level = aLevel;
	this.isLastNode = aLastNode;

	aLevel = aLevel + 1
	
	for(var i = 0; i < this.ChildCount; i++)
	{
		if (i == this.ChildCount - 1)
		{
			this.Child[i].Initialise(aLevel, true);
		}
		else
		{
			this.Child[i].Initialise(aLevel, false);
		}
	}	
}

function CollapseFolder()
{
	this.Expand = false;
	for(var i = 0 ; i < this.ChildCount; i++)
	{
		if(this.Child[i].Type == "Folder")
		{
			this.Child[i].Collapse();
		}
	}
}

function CItem(aCaption, aLink, aIcon)
{
	this.Index = 0;
	this.Type = "Item";
	this.Caption = aCaption;
	this.PageLink = aLink;
	this.Selected = false;
	this.Icon = aIcon; 
	this.Level = 0;
	this.isLastNode = false;

	this.Initialise = InitialiseItem;
	this.CreateNode = CreateNode;
}

function InitialiseItem(aLevel, aLastNode)
{
	this.CreateNode();
	this.Level = aLevel;
	this.isLastNode = aLastNode;
}

function AddFolder(aParentNode, aCaption, aIcon)
{
	var Folder = new CFolder(aCaption, aIcon);
	return aParentNode.AddChild(Folder)
}

function AddItem(aParentNode, aCaption, aLink, aIcon)
{
	var Item = new CItem(aCaption, aLink, aIcon);
	aParentNode.AddChild(Item);
}

function NodeOnClick(aNodeIndex)
{
	if(Node[aNodeIndex].Expand)
	{ 
			WriteText("Node" + aNodeIndex, Node[aNodeIndex].HTMLCollapse);
			Node[aNodeIndex].Collapse();
	}
	else
	{
		WriteText("Node" + aNodeIndex, Node[aNodeIndex].HTMLExpand);
		Node[aNodeIndex].Expand = true;
		for(var j = 0; j < Node[aNodeIndex].ChildCount; j++)
		{
			if(Node[aNodeIndex].Child[j].Type == "Item")
			{	
				if(Node[aNodeIndex].Child[j].Selected)
				{
					var Pointer = eval("document.Pointer" + Node[aNodeIndex].Child[j].Index);
					Pointer.src = ActiveP.src;
				}
			}
		}
	}
}

function CreateNode()
{
	this.Index = NodeIndex;
	Node[NodeIndex] = this;
	NodeIndex++;
}

// Gload Tree Variable
var NodeIndex = 0;
var ImagePath = "";
var Node = new Array;

function PreloadImage()
{
	var Img = new Image;
	Img.src = ImagePath + "images/TreeNode.gif";
	Img.src = ImagePath + "images/TreeNegNode.gif";
	Img.src = ImagePath + "images/TreeNegLastNode.gif";
	Img.src = ImagePath + "images/TreePosNode.gif";
	Img.src = ImagePath + "images/TreePostLastNode.gif";
	Img.src = ImagePath + "images/TreeVLine.gif";
}

function InitialiseTree()
{
	PreloadImage();
	Tree.Initialise(0, false);
	for(var i = 1; i < NodeIndex; i++)
	{
		if(Node[i].Type == "Folder")
		{
			Node[i].HTMLCollapse += "<div id='Node" + i + "'>"
														+ "<table cellpadding=0 cellspacing=0 border=0 width='100%'>"
														+ "<tr>"
														+ "<td width=16>";
			
			Node[i].HTMLExpand += Node[i].HTMLCollapse;

			if(Node[i].ChildCount > 0)
			{
				if(Node[i].isLastNode)
				{
					Node[i].HTMLCollapse += "<a href='javascript:NodeOnClick(" + i + ")' onMouseOver=\"window.status='Expand'; return true;\" onMouseOut=\"window.status=''; return true;\"><img src='" + ImagePath + "images/TreePosLastNode.gif' width=16 height=22 border=0 alt='Expand'></a>";
					Node[i].HTMLExpand += "<a href='javascript:NodeOnClick(" + i + ")' onMouseOver=\"window.status='Collapse'; return true;\" onMouseOut=\"window.status=''; return true;\"><img src='" + ImagePath + "images/TreeNegLastNode.gif' width=16 height=22 border=0 alt='Collapse'></a>" 
				}
				else
				{
					Node[i].HTMLCollapse += "<a href='javascript:NodeOnClick(" + i + ")' onMouseOver=\"window.status='Expand'; return true;\" onMouseOut=\"window.status=''; return true;\"><img src='" + ImagePath + "images/TreePosNode.gif' width=16 height=22 border=0 alt='Expand'></a>";
					Node[i].HTMLExpand += "<a href='javascript:NodeOnClick(" + i + ")' onMouseOver=\"window.status='Collapse'; return true;\" onMouseOut=\"window.status=''; return true;\"><img src='" + ImagePath + "images/TreeNegNode.gif' width=16 height=22 border=0 alt='Collapse'></a>"
				}
			}
			else
			{
				if(Node[i].isLastNode)
				{
					Node[i].HTMLCollapse += "<img src='" + ImagePath + "images/TreeLastNode.gif' width=16 height=22 border=0>";
					Node[i].HTMLExpand += "<img src='" + ImagePath + "images/TreeLastNode.gif' width=16 height=22 border=0";
				}
				else
				{
					Node[i].HTMLCollapse += "<img src='" + ImagePath + "images/TreeNode.gif' width=16 height=22 border=0>";
					Node[i].HTMLExpand += "<img src='" + ImagePath + "images/TreeNode.gif' width=16 height=22 border=0";
				}
			}

			Node[i].HTMLCollapse += "</td>"
														+ "<td width=16><img src='" + ImagePath + Node[i].Icon + "' width=16 height=16 border=0></td>"
														+ "<td width='100%' colspan=2><a href='javascript:NodeOnClick(" + i + ")' onMouseOver=\"window.status='Expand'; return true;\" onMouseOut=\"window.status=''; return true;\" class='links'>&nbsp;" + Node[i].Caption + "</a></td>"
														+ "</tr>";

			Node[i].HTMLExpand += "</a></td>"
														+ "<td width=16><img src='" + ImagePath + Node[i].Icon + "' width=16 height=16 border=0></td>"
														+ "<td width='100%' colspan=2><a href='javascript:NodeOnClick(" + i + ")' onMouseOver=\"window.status='Collapse'; return true;\" onMouseOut=\"window.status=''; return true;\" class='links'>&nbsp;" + Node[i].Caption + "</a></td>"
														+ "</tr>";

			for(var j = 0; j < Node[i].ChildCount; j++)
			{
				if(Node[i].Child[j].Type == "Folder")
				{
					Node[i].HTMLExpand += "<tr>";

					if(Node[i].isLastNode)
					{
						Node[i].HTMLExpand += "<td><img src='" + ImagePath + "images/1x1.gif' width=16 height=1 border=0></td>"; 
					}
					else
					{
						Node[i].HTMLExpand += "<td background='" + ImagePath + "images/TreeVLine.gif'><img src='" + ImagePath + "images/1x1.gif' width=16 height=1 border=0></td>";
					}

					Node[i].HTMLExpand += "<td colspan=3>";

					Node[i].HTMLExpand += "<div id='Node" + Node[i].Child[j].Index + "'>"
															+ "<table cellpadding=0 cellspacing=0 border=0 width='100%'>"
															+ "<tr>"
															+ "<td width=16>";

					if(Node[i].Child[j].ChildCount > 0)
					{
						if(Node[i].Child[j].isLastNode)
						{
							Node[i].HTMLExpand += "<a href='javascript:NodeOnClick(" + Node[i].Child[j].Index + ")' onMouseOver=\"window.status='Expand'; return true;\" onMouseOut=\"window.status=''; return true;\"><img src='" + ImagePath + "images/TreePosLastNode.gif' width=16 height=22 border=0 alt='Expand'></a>";
						}
						else
						{
							Node[i].HTMLExpand += "<a href='javascript:NodeOnClick(" + Node[i].Child[j].Index + ")' onMouseOver=\"window.status='Expand'; return true;\" onMouseOut=\"window.status=''; return true;\"><img src='" + ImagePath + "images/TreePosNode.gif' width=16 height=22 border=0 alt='Expand'></a>";
						}
					}
					else
					{
						if(Node[i].Child[j].isLastNode)
						{
							Node[i].HTMLExpand += "<img src='" + ImagePath + "images/TreeLastNode.gif' width=16 height=22 border=0>";
						}
						else
						{
							Node[i].HTMLExpand += "<img src='" + ImagePath + "images/TreeNode.gif' width=16 height=22 border=0>";
						}
					}

					Node[i].HTMLExpand += "</td>"
															+ "<td width=16><img src='" + ImagePath + Node[i].Child[j].Icon + "' width=16 height=16 border=0></td>"
															+ "<td width='100%'><a href='javascript:NodeOnClick(" + Node[i].Child[j].Index + ")' onMouseOver=\"window.status='Expand'; return true;\" onMouseOut=\"window.status=''; return true;\" class='links'>&nbsp;" + Node[i].Child[j].Caption + "</a></td>"
															+ "</tr>"
															+ "</table>"
															+ "</div>";

					Node[i].HTMLExpand += "</td>"
															+ "</tr>";
				}
				else
				{
					Node[i].HTMLExpand += "<tr>";
	
					if(Node[i].isLastNode)
					{
						Node[i].HTMLExpand += "<td width=16><img src='" + ImagePath + "images/1x1.gif' width=16 height=1 border=0></td>"
					}
					else
					{
						Node[i].HTMLExpand += "<td background='" + ImagePath + "images/TreeVLine.gif'><img src='" + ImagePath + "images/1x1.gif' width=16 height=1 border=0></td>";
					}

					if(Node[i].Child[j].isLastNode)
					{
						Node[i].HTMLExpand += "<td width=16><img src='" + ImagePath + "images/TreeLastNode.gif' width=16 height=22 border=0></td>";
					}
					else
					{
						Node[i].HTMLExpand += "<td width=16><img src='" + ImagePath + "images/TreeNode.gif' width=16 height=22 border=0></td>";
					}

					Node[i].HTMLExpand += "<td width=16><img src='" + ImagePath + Node[i].Child[j].Icon + "' width=16 height=16 border=0></td>"
															+ "<td width='100%' nowrap><nobr><a href='javascript:SetRecord(" + Node[i].Child[j].PageLink + "," + Node[i].Child[j].Index + ");' onMouseOver=\"window.status='Load Data'; return true;\" onMouseOut=\"window.status=''; return true;\" class='links'>&nbsp;" + Node[i].Child[j].Caption + "</a>"
															+ "<img src='" + ImagePath + "images/1x1.gif' name='Pointer" + Node[i].Child[j].Index + "' width=14 height=12 border=0></nobr></td>"
															+ "</tr>";
				}
			}

			Node[i].HTMLExpand += "</table></div>";

			Node[i].HTMLCollapse += "</table></div>";

			if(Node[i].Level == 1)
			{
				document.write(Node[i].HTMLCollapse);
			}
		}
	}	
}

// End Tree Code