(*      TCoolorDialog  Version 1.2       *)
(*  Copyright (C) 2000 Greatis Software  *)
(*      web: http://www.greatis.com      *)
(*      e-mail: b-team@greatis.com       *)

unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Coolor, StdCtrls, IniFiles, ExtCtrls, ShellAPI, Colors;

type
  TfrmDemo = class(TForm)
    btnDemo: TButton;
    cmpCoolorDialog: TCoolorDialog;
    rgrActivePage: TRadioGroup;
    grbVisiblePages: TGroupBox;
    chbVGA: TCheckBox;
    chbInternet: TCheckBox;
    chbHSB: TCheckBox;
    chbRGB: TCheckBox;
    chbCMY: TCheckBox;
    chbGray: TCheckBox;
    chbWindows: TCheckBox;
    chbInfo: TCheckBox;
    chbHelpButton: TCheckBox;
    chbAutoHelpContext: TCheckBox;
    pnlColor: TPanel;
    pnlReferenceColor: TPanel;
    lblReferenceColor: TLabel;
    lblColor: TLabel;
    btnExit: TButton;
    lblCopyright: TLabel;
    lblHTTP: TLabel;
    lblCaption: TLabel;
    edtCaption: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnDemoClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure lblHTTPClick(Sender: TObject);
  private
    { Private declarations }
    function ApplicationHelp(Command: Word; Data: Longint; var CallHelp: Boolean): Boolean;
  public
    { Public declarations }
  end;

var
  frmDemo: TfrmDemo;

implementation

{$R *.DFM}

function TfrmDemo.ApplicationHelp(Command: Word; Data: Longint; var CallHelp: Boolean): Boolean;
begin
  Result:=True;
  CallHelp:=False;
  ShowMessage('Help system call'#13'Help context = '+IntToStr(Data));
end;

procedure TfrmDemo.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  // setting help emulation event
  Application.OnHelp:=ApplicationHelp;
  // loading user colors from IniFile
  with cmpCoolorDialog,TIniFile.Create(ChangeFileExt(ParamStr(0),'.ini')) do
  try
    for i:=1 to UserColorCount do
      UserColors[i]:=RGBHexToColor(ReadString('My colors',IntToStr(i),ColorToRGBHex(clSilver)));
  finally
    Free;
  end;
end;

procedure TfrmDemo.FormDestroy(Sender: TObject);
var
  i: Integer;
begin
  // saving user colors to IniFile
  with cmpCoolorDialog,TIniFile.Create(ChangeFileExt(ParamStr(0),'.ini')) do
  try
    for i:=1 to UserColorCount do
      WriteString('My colors',IntToStr(i),ColorToRGBHex(UserColors[i]));
  finally
    Free;
  end;
end;

procedure TfrmDemo.btnDemoClick(Sender: TObject);
var
  i: Integer;
begin
  with cmpCoolorDialog do
  begin
    // setting properties from controls
    ActivePage:=TDialogPage(rgrActivePage.ItemIndex);
    VisiblePages:=[];
    HelpButton:=chbHelpButton.Checked;
    AutoHelpContext:=chbAutoHelpContext.Checked;
    with grbVisiblePages do
      for i:=0 to Pred(ControlCount) do
        with Controls[i] as TCheckBox do
          if Checked then VisiblePages:=VisiblePages+[TDialogPage(i)];
    ReferenceColor:=pnlReferenceColor.Color;
    Color:=pnlColor.Color;
    Caption:=edtCaption.Text;
    // executing TCoolorDialog
    if Execute then
    begin
      // getting colors
      pnlReferenceColor.Color:=ReferenceColor;
      pnlColor.Color:=Color;
      // showing color parameters
      with HSBColor,RGBColor,CMYColor do
        ShowMessage(
          'HSB: Hue='+IntToStr(Hue)+', Saturation='+IntToStr(Saturation)+', Brightness='+IntToStr(Brightness)+
          #13'RGB: Red='+IntToStr(Red)+', Green='+IntToStr(Green)+', Blue='+IntToStr(Blue)+
          #13'CMY: Cyan='+IntToStr(Cyan)+', Magenta='+IntToStr(Magenta)+', Yellow='+IntToStr(Yellow)+
          #13'RBGHex: '+RGBHex+
          #13'HTML: '+HTMLColor);
    end;
    rgrActivePage.ItemIndex:=Integer(ActivePage);
  end;
end;

procedure TfrmDemo.btnExitClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TfrmDemo.lblHTTPClick(Sender: TObject);
begin
  ShellExecute(0,'open',PChar(lblHTTP.Caption),'','',SW_SHOWMAXIMIZED);
end;

end.
