unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, GraphLnk, ExtCtrls;

type
  TForm1 = class(TForm)
    GraphLink1: TGraphLink;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    GraphLink4: TGraphLink;
    Memo1: TMemo;
    SpinButton1: TSpinButton;
    Edit1: TEdit;
    Label4: TLabel;
    GraphLink2: TGraphLink;
    GraphLink3: TGraphLink;
    GraphLink5: TGraphLink;
    GroupBox1: TGroupBox;
    Shape1: TShape;
    Shape2: TShape;
    Link: TGraphLink;
    Memo2: TMemo;
    GraphLink6: TGraphLink;
    Label5: TLabel;
    Label6: TLabel;
    MultiLink: TGraphLink;
    ShapeMStart: TShape;
    ShapeMEnd: TShape;
    procedure AdjustLink;
    procedure SpinButton1DownClick(Sender: TObject);
    procedure SpinButton1UpClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Shape1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Shape1EndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure GroupBox1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure Shape1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure LinkDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure PutMessage(Sender: TObject; Button: TMouseButton;
                         Shift: TShiftState; X, Y: Integer);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.AdjustLink;
begin
  Link.UpdateLink;
end;

procedure TForm1.PutMessage(Sender: TObject; Button: TMouseButton;
                     Shift: TShiftState; X, Y: Integer);
begin
ShowMessage('MouseDown (or Click) accepted');
end;

procedure Set_Contact_Distance(I: Integer);
var K: Integer;
begin
with Form1 do begin
  for K:=0 to ControlCount-1 do if Controls[K] is TGraphLink then
    (Controls[K] as TGraphLink).ContactDistance:=I;
  Link.ContactDistance:=I;
  end;
end;

procedure TForm1.SpinButton1DownClick(Sender: TObject);
var I: Integer;
begin
I:=StrToInt(Edit1.Text);
if I > 0 then begin
  Dec(I);
  Edit1.Text:=IntToStr(I);
  Set_Contact_Distance(I);
  end;
end;

procedure TForm1.SpinButton1UpClick(Sender: TObject);
var I: Integer;
begin
I:=StrToInt(Edit1.Text);
Inc(I);
Edit1.Text:=IntToStr(I);
Set_Contact_Distance(I);
end;

procedure TForm1.FormShow(Sender: TObject);
var K,dy: Integer;
  procedure Shift_All_Controls_To_Centre_Of_Form;
  var XMin, XMax, X: Integer;
      I: Integer;
  begin
  XMin:=ClientWidth;
  XMax:=0;
  for I:=0 to ControlCount-1 do with Controls[I] do begin
    if Left < XMin then
      XMin:=Left;
    if (Left+Width) > XMax then
      XMax:=Left + Width;
    end;
  X:=(ClientWidth - XMax + XMin) div 2;
  for I:=0 to ControlCount-1 do with Controls[I] do
    Left:=Left + X;
  end;
begin
Shift_All_Controls_To_Centre_Of_Form;
Set_Contact_Distance(0);
for K:=0 to ControlCount-1 do if Controls[K] is TGraphLink then
  (Controls[K] as TGraphLink).OnMouseDown:=PutMessage;
Link.StartControl:=Shape1;
Link.EndControl:=Shape2;
with MultiLink do begin
  StartControl:=ShapeMStart;
  EndControl:=ShapeMEnd;
  {ShowMessage(IntToStr(StartPoint.X)+' '+IntToStr(StartPoint.Y));}
  dy:=(EndPoint.Y-StartPoint.Y) div 3;
  Points.InsertPoint(1,EndPoint.X,StartPoint.Y+dy);
  Points.InsertPoint(2,StartPoint.X,StartPoint.Y+dy+dy);
  end;
end;

procedure TForm1.Shape1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbRight then begin
    (Sender as TControl).BeginDrag(False);
    end;
end;

procedure TForm1.Shape1EndDrag(Sender, Target: TObject; X, Y: Integer);
begin
{ Error in Delphi 2 & 3 and C++Builder ??? :
  Sender is not accepted but Target is not NIL  }
  if (Target <> nil) and 
     ((Target=GroupBox1) or (GroupBox1.ContainsControl(Target as TControl)))
  then begin
    if Target=Sender then Exit;
    with Sender as TControl do begin
      Top:=Y - Height div 2; 
      Left:=X - Width div 2;
      if Target <> GroupBox1 then begin
        Top:= Top + (Target as TControl).Top;
        Left:=Left + (Target as TControl).Left;
        end;
      end;
    AdjustLink;
    end;
end;

procedure TForm1.GroupBox1DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  if Source is TShape then Accept:=True;
  if Source is TShape then with Source as TShape do begin
    Top:=Y - Height div 2; 
    Left:=X - Width div 2;
    AdjustLink;
    end;
end;

procedure TForm1.Shape1DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  if Source is TShape then Accept:=True;
end;

procedure TForm1.LinkDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  if Source is TShape then Accept:=True;
end;

end.
 