unit InputDev;

{  ******
   *
   * Module:    InputDev
   * Author:    Joe Kessler
   *            IntegrationWare - A New Generation of Extraordinary PC Solutions
   *            www.integrationware.com
   *
   * Purpose:
   *
   *    The TInputDevice class is the ultimate ancestor of all Rocks input
   *    devices.  New input methods (such as mice, joystick, etc...) can be
   *    implemented by deriving from this class.
   *
   ****** }

interface
uses Input, Classes;

type TInputDevice = class(TObject)
    public

        { Class constructor and destructor. }
        constructor Create;
        destructor Destroy; Override;

        { Method to define a logical input.  This has nothing to do with key
          mappings, or button presses.  It respresents a logical input, which
          may be triggered by one of those inputs.  This triggering behavior
          is defined by the derived classes. }
        procedure DefineInput(iInputCode: Integer);

        { Method to give access to an individual input with the given code. }
        function inpGetInput(iInputCode: Integer): TInput;

    private

        m_lstInputs: TList;     { List of all logical inputs. }
end;

implementation

constructor TInputDevice.Create;
begin
    { Default constructor. }
    inherited Create;

    { Create a list to manage logical inputs. }
    m_lstInputs := TList.Create;
end;

destructor TInputDevice.Destroy;
var
    iIndex: Integer;
begin
    { Delete all of the defined inputs. }
    for iIndex := (m_lstInputs.Count - 1) downto 0 do
        m_lstInputs.Delete(iIndex);
    m_lstInputs.Free;

    { Perform default cleanup. }
    inherited Destroy;
end;

procedure TInputDevice.DefineInput(iInputCode: Integer);
var
    inpNew: TInput;
begin
    { Create a new input object. }
    inpNew := TInput.Create(iInputCode);

    { Add the input object to the list. }
    m_lstInputs.Add(inpNew);
end;

function TInputDevice.inpGetInput(iInputCode: Integer): TInput;
var
    iIndex: Integer;
begin
    { Look for the input object in the list. }
    for iIndex := 0 to (m_lstInputs.Count - 1) do
    begin
        Result := m_lstInputs.Items[iIndex];
        if (Result.iGetInputCode = iInputCode) then
            Exit;
    end;

    { Return NULL if the object can't be found. }
    Result := nil;
 end;

end.
