unit Missle;

{  ******
   *
   * Module:    Missle
   * Author:    Joe Kessler
   *            IntegrationWare - A New Generation of Extraordinary PC Solutions
   *            www.integrationware.com
   *
   * Purpose:
   *
   *    This module defines the look and behavior of a Missle.  Missles are
   *    fired by Aliens and by Bart.
   *
   ****** }

interface

uses SoundDev, Visible, Vertex,
     Forms, WinTypes, Graphics, Classes;

type TMissle = class(TVisibleObject)
public
   { *** Our constructor *** }
   constructor Create(listObjects: TList; iCollisionID: Integer);

   procedure Move; Override;
   procedure HandleCollision(objOtherObject: TVisibleObject); Override;

private
    m_iLife: Integer;   { Total possible lifespan of a missle in movement "ticks". }
    m_iAge: Integer;    { Number of "ticks" since the missle was fired. }
end;

implementation

uses General;

constructor TMissle.Create(listObjects: TList; iCollisionID: Integer);
var
    vtxOne, vtxTwo, vtxThree: TVertex;
begin
    inherited Create(listObjects, iCollisionID);

    { Establish the lifespan of the missle. }
    m_iLife := 35;
    m_iAge := 0;

    { Set up the speed of the missle. }
    mtrxTransform.fSpeed := 10.0;

    { Define the shape of the missle at a simple triangle. }
    vtxOne := vtxDefineNewVertex(-2, 0);
    vtxTwo := vtxDefineNewVertex( 0, 2);
    vtxThree := vtxDefineNewVertex( 2, 0);
    edgeDefineNewEdge(vtxOne, vtxTwo, clYellow, True);
    edgeDefineNewEdge(vtxTwo, vtxThree, clYellow, False);
    edgeDefineNewEdge(vtxThree, vtxOne, clYellow, False);
end;

procedure TMissle.Move;
begin
    { If the missile has used up its fuel, then it's time to die.  A missle
      that runs out of fuel will visually disintegrate. }
    if (m_iAge > m_iLife) then
        KillObject(True, 25, 0.25, 0.25, 1.0);

    { Do the default movement stuff. }
    inherited Move;

    { If the missle is off the screen, then wrap around. }
    if bIsRectOffScreen(rectGetBoundingRect) then
        Wrap;

    { Increase our age counter. }
    Inc(m_iAge);
end;

procedure TMissle.HandleCollision(objOtherObject: TVisibleObject);
begin
    // When collision occurs, the missle will be obliterated.
    KillObject(False, 0, 0, 0, 0);
end;

end.

