unit Vertex;

{  ******
   *
   * Module:    Vertex
   * Author:    Joe Kessler
   *            IntegrationWare - A New Generation of Extraordinary PC Solutions
   *            www.integrationware.com
   *
   * Purpose:
   *
   *    This module defines a vertex.  Vertices, along with edges, define the
   *    shape of a visible object.  Vertices are scaled, rotated, and moved
   *    around, while edges describ a relationship between two vertices.
   *
   ****** }

interface

type TVertex = Class(TObject)
    public
        m_fLocalX, m_fLocalY: Real;             { Original local coordinates. }
        m_fTransformedX, m_fTransformedY: Real; { Transformed local coordinates. }
        m_fScreenX, m_fScreenY: Real;           { Translated and transformed coordinates. }
        m_iLastDrawnX, m_iLastDrawnY: Integer;  { Screen coordinates as of last redraw. }
        m_bUsed: Boolean;                       { TRUE if vertex is used by an object. }
end;
type PVertex = ^TVertex;

implementation

end.
