unit DatamatrixDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,Datamatrix;

type
  TDMDemo = class(TForm)
    Image1: TImage;
    txtCode: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    cEncoding: TComboBox;
    cFormat: TComboBox;
    Label4: TLabel;
    txtSize: TEdit;
    Margin: TLabel;
    txtMargin: TEdit;
    btnRefresh: TButton;
    btnExit: TButton;
    btnPrint: TButton;
    Label5: TLabel;
    txtPrinterSize: TEdit;
    Button1: TButton;
    procedure btnRefreshClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    datamatrix:TDatamatrix;
  public
    { Public declarations }
  end;

var
  DMDemo: TDMDemo;

implementation
uses Printers;
{$R *.DFM}

procedure TDMDemo.btnRefreshClick(Sender: TObject);
var
dummy:integer;
value:integer;
begin


{create new barcode}
{encoding}
if (cEncoding.itemIndex>=0) then datamatrix.encoding:=TEncoding(cEncoding.itemIndex)
else datamatrix.encoding:=E_AUTO;
{value}
datamatrix.code:=txtCode.text;
datamatrix.processTilde:=true;
{format}
if (cFormat.itemIndex>=0) then datamatrix.preferredFormat:=TFormat(cFormat.itemIndex)
else datamatrix.preferredFormat:=AUTO;
{dots size}
val(txtSize.text,value,dummy);
datamatrix.PixelsDot:=value;
{margin}
val(txtMargin.text,value,dummy);
datamatrix.margin:=value;

datamatrix.rebuild:=true;
datamatrix.paintBarcode(Image1.Canvas);

end;

procedure TDMDemo.FormCreate(Sender: TObject);
begin
datamatrix:=TDatamatrix.Create(nil) ;
{refresh}
btnRefreshClick(nil);
cEncoding.itemIndex:=5 ; //ord(E_AUTO);
cFormat.itemIndex:=ord(AUTO);

end;

procedure TDMDemo.btnExitClick(Sender: TObject);
begin
hide();
end;

procedure TDMDemo.btnPrintClick(Sender: TObject);
var
value:integer;
dummy:integer;
begin
     with printer do
     begin
		BeginDoc;

                {dots size}
                val(txtPrinterSize.text,value,dummy);
                datamatrix.PixelsDot:=value;

                datamatrix.margin:=printer.PageWidth div 10;
		datamatrix.paintBarcode(Canvas);

		EndDoc;
     end;
end;

procedure TDMDemo.Button1Click(Sender: TObject);
var
bmp:TBitmap;
begin
       bmp:=TBitmap.create();
     bmp.height:=200;
     bmp.width:=200;
     datamatrix.paintBarcode(bmp.Canvas);
     bmp.SaveToFile('datamatrix.bmp');

     MessageDlg('Image saved to datamatrix.bmp.', mtInformation,      [mbOk], 0);

end;

end.
