/*==============================================================================

  Mail merge application: part 1 - template editor.
  Editing template and data for fields.

  Template: RVStyle for template (RVStyle2) has two text styles
  (0-th for normal text, 1 - for fields (with special Protection options)
  Other styles can be added dynamically (right-click editor in C++Builder,
  "Settings" in the context menu).
  Template is stored in Template.rvf.

  Data for fields: stored in Database.db.
  There are two fields:
  - Code - string field
  - Data - rvf field.
  Styles can be added dynamically in Data editor.

==============================================================================*/
#include <vcl.h>
#pragma hdrstop

#include "TEMainFrm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "DBRV"
#pragma link "RichView"
#pragma link "RVEdit"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DataSource1DataChange(TObject *Sender,
      TField *Field)
{
  if (Table1->RecordCount==0)
    Label2->Caption = "(empty)";
  else if (Table1->RecNo<1)
    Label2->Caption = "(new)";
  else
    Label2->Caption = Format("Record %d of %d", ARRAYOFCONST((Table1->RecNo, Table1->RecordCount)));
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RichViewEdit1->Clear();
  RichViewEdit1->LoadRVF(ExtractFilePath(Application->ExeName)+"template.rvf");
  RichViewEdit1->Format();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
  if (Table1->State==dsEdit || Table1->State==dsInsert)
    Table1->Post();
  RichViewEdit1->SaveRVF(ExtractFilePath(Application->ExeName)+"template.rvf", false);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  AnsiString s = "";
  if (InputQuery("Insert Field", "Field code:", s))
  {
    if (s=="")
      return;
    // s must be equal to one of Codes in the database
    RichViewEdit1->SetFocus();
    RichViewEdit1->CurTextStyleNo = 1;
    RichViewEdit1->InsertText(s, false);
  }
}
//---------------------------------------------------------------------------

