// Properties:
// rvoTagsArePChars is added in Options
// rvoCtrlJumps is added in EditorOptions
// "Allow adding styles dynamically" in the "Settings" in the context menu

// This code is highly simplified.
// RichViewActions use much more advanced code for inserting hyperlinks.
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <shellapi.h>
#pragma hdrstop

#include "Unit1.h"
#include "Unit2.h"
//---------------------------------------------------------------------------
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichViewEdit1Select(TObject *Sender)
{
  SpeedButton1->Enabled = RichViewEdit1->SelectionExists() && ! RichViewEdit1->ReadOnly;	
}
//---------------------------------------------------------------------------
void TForm1::SetURLToSelection(const AnsiString URL)
{
  int StartNo, EndNo, StartOffs, EndOffs;
  TCustomRichViewEdit* rve = RichViewEdit1->TopLevelEditor;
  rve->GetSelectionBounds(StartNo, StartOffs, EndNo, EndOffs, true);
  if (StartOffs >= rve->GetOffsAfterItem(StartNo))
    StartNo++;
  if (EndOffs <= rve->GetOffsBeforeItem(EndNo))
    EndNo--;
  rve->BeginUndoGroup(rvutTag);
  rve->SetUndoGroupMode(true);
  for (int i=StartNo; i<=EndNo; i++)
    rve->SetItemTagEd(i, (int)StrNew(URL.c_str()));
  rve->SetUndoGroupMode(false);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SpeedButton1Click(TObject *Sender)
{
  AnsiString URL = (char*)RichViewEdit1->GetCurrentTag();
  if (URL.IsEmpty())
    URL = "http://";
  Form2->Edit1->Text = URL;
  if (Form2->ShowModal()==mrOk)
  {
    RichViewEdit1->ApplyTextStyle(4);
    URL = Form2->Edit1->Text;
    SetURLToSelection(URL);
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichViewEdit1Jump(TObject *Sender, int id)
{
  TCustomRVFormattedData* RVData;
  int ItemNo;
  RichViewEdit1->GetJumpPointLocation(id, RVData, ItemNo);
  AnsiString URL = (char*)RVData->GetItemTag(ItemNo);
  ShellExecute(0, "open", URL.c_str(), NULL, NULL, SW_SHOW);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RichViewEdit1->Clear();
  RichViewEdit1->AddNL("Select text and click the button",0,0);
  RichViewEdit1->Format();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CheckBox1Click(TObject *Sender)
{
  RichViewEdit1->ReadOnly = CheckBox1->Checked;
  if (CheckBox1->Checked)
    RichViewEdit1->Color = clBtnFace;
  else
    RichViewEdit1->Color = clWindow;
  RichViewEdit1Select(Sender);
  RichViewEdit1->SetFocus();
}
//---------------------------------------------------------------------------