unit Unit1;

// Properties:
// rvoTagsArePChars is added in Options
// rvoCtrlJumps is added in EditorOptions
// "Allow adding styles dynamically" in the "Settings" in the context menu

// This code is highly simplified.
// RichViewActions use much more advanced code for inserting hyperlinks.

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  RVStyle, RVScroll, RichView, RVEdit, Buttons, ExtCtrls, Unit2, CRVFData,
  ShellApi, StdCtrls;

type
  TForm1 = class(TForm)
    RichViewEdit1: TRichViewEdit;
    RVStyle1: TRVStyle;
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    CheckBox1: TCheckBox;
    procedure RichViewEdit1Select(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure RichViewEdit1Jump(Sender: TObject; id: Integer);
    procedure FormCreate(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
  private
    procedure SetURLToSelection(const URL: String);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.RichViewEdit1Select(Sender: TObject);
begin
  SpeedButton1.Enabled := RichViewEdit1.SelectionExists and not RichViewEdit1.ReadOnly;
end;

procedure TForm1.SetURLToSelection(const URL: String);
var i, StartNo, EndNo, StartOffs, EndOffs: Integer;
    rve: TCustomRichViewEdit;
begin
  rve := RichViewEdit1.TopLevelEditor;
  rve.GetSelectionBounds(StartNo, StartOffs, EndNo, EndOffs, True);
  if StartOffs >= rve.GetOffsAfterItem(StartNo) then
    inc(StartNo);
  if EndOffs <= rve.GetOffsBeforeItem(EndNo) then
    dec(EndNo);
  rve.BeginUndoGroup(rvutTag);
  rve.SetUndoGroupMode(True);
  for i := StartNo to EndNo do
    rve.SetItemTagEd(i, Integer(StrNew(PChar(URL))));
  rve.SetUndoGroupMode(False);
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
var URL: String;
begin
  URL := PChar(RichViewEdit1.GetCurrentTag);
  if URL='' then
    URL := 'http://';
  Form2.Edit1.Text := URL;
  if Form2.ShowModal=mrOk then begin
    RichViewEdit1.ApplyTextStyle(4);
    URL := Form2.Edit1.Text;
    SetURLToSelection(URL);
  end;
end;

procedure TForm1.RichViewEdit1Jump(Sender: TObject; id: Integer);
var URL: String;
    RVData: TCustomRVFormattedData;
    ItemNo: Integer;
begin
  RichViewEdit1.GetJumpPointLocation(id, RVData, ItemNo);
  URL := PChar(RVData.GetItemTag(ItemNo));
  ShellExecute(0, 'open', PChar(URL), nil, nil, SW_SHOW);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  RichViewEdit1.Clear;
  RichViewEdit1.AddNL('Select text and click the button',0,0);
  RichViewEdit1.Format;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  RichViewEdit1.ReadOnly := CheckBox1.Checked;
  if CheckBox1.Checked then
    RichViewEdit1.Color := clBtnFace
  else
    RichViewEdit1.Color := clWindow;
  RichViewEdit1Select(Sender);
  RichViewEdit1.SetFocus;
end;

end.
