unit Main;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, ComCtrls, StdActns,
  ActnList, ToolWin, ImgList, abActnLst, abSecurity;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileCloseItem: TMenuItem;
    Window1: TMenuItem;
    Help1: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowTileItem: TMenuItem;
    WindowArrangeItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    OpenDialog: TOpenDialog;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    Edit1: TMenuItem;
    CutItem: TMenuItem;
    CopyItem: TMenuItem;
    PasteItem: TMenuItem;
    WindowMinimizeItem: TMenuItem;
    StatusBar: TStatusBar;
    WindowTileItem2: TMenuItem;
    ToolBar2: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton9: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    BitBtn1: TBitBtn;
    Button1: TButton;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    ImageList1: TImageList;
    abSecurity1: TabSecurity;
    abActionList1: TabActionList;
    abFileNew1: TabAction;
    abFileOpen1: TabAction;
    abFileClose1: TabAction;
    abFileSave1: TabAction;
    abFileSaveAs1: TabAction;
    abFileExit1: TabAction;
    abEditCut1: TabAction;
    abEditCopy1: TabAction;
    abEditPaste1: TabAction;
    abWindowCascade1: TabAction;
    abWindowTileHorizontal1: TabAction;
    abWindowTileVertical1: TabAction;
    abWindowMinimizeAll1: TabAction;
    abWindowArrangeAll1: TabAction;
    abHelpAbout1: TabAction;
    mmoMainWnd: TMemo;
    abAutoGenerated: TabAction;
    procedure FileNew1Execute(Sender: TObject);
    procedure FileOpen1Execute(Sender: TObject);
    procedure HelpAbout1Execute(Sender: TObject);
    procedure FileExit1Execute(Sender: TObject);
    procedure abactCheckRightsExecute(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FileClose1Execute(Sender: TObject);
    procedure abactChangeLogonExecute(Sender: TObject);
  private
    { Private declarations }
    procedure CreateMDIChild(const Name: string);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses ChildWin, About;

procedure TMainForm.CreateMDIChild(const Name: string);
var
  Child: TMDIChild;
begin
  { create a new MDI child window }
  Child := TMDIChild.Create(Application);
  Child.Caption := Name;
  if FileExists(Name) then Child.Memo1.Lines.LoadFromFile(Name);
end;

procedure TMainForm.FileNew1Execute(Sender: TObject);
begin
  CreateMDIChild('NONAME' + IntToStr(MDIChildCount + 1));
end;

procedure TMainForm.FileOpen1Execute(Sender: TObject);
begin
  if OpenDialog.Execute then
    CreateMDIChild(OpenDialog.FileName);
end;

procedure TMainForm.HelpAbout1Execute(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TMainForm.FileExit1Execute(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.abactCheckRightsExecute(Sender: TObject);
begin
  abSecurity1.ShowPrivileges;
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
  if abSecurity1.CheckId(30) then
    ShowMessage('ID 30 Enabled')
  else
    ShowMessage('ID 30 Disabled');
end;

procedure TMainForm.FileClose1Execute(Sender: TObject);
begin
  if Assigned(ActiveMDIChild) then
    ActiveMDIChild.Close;
end;

procedure TMainForm.abactChangeLogonExecute(Sender: TObject);
begin
  abSecurity1.Logon;
end;

end.
   