#include <windows.h>
#include <commdlg.h>
#include <string.h>
#include "findfuncs.h"

// Original functions by Charles Petzold but these were buggy so
// I rewrote them to be more stable and added functionality.

// ----------------------------------------------------------------------------

// return values
// -1  : text not found
// >=0 : position of text found
int FindText (HWND hwndEdit, FINDREPLACE* pFindRplc)
{
    int         memLen  = GetWindowTextLength(hwndEdit);
    // quick and dirty hace to prevent access violations when searching for 
    // strings backwards through text.
    char*       pFndMem = new char[memLen+strlen(pFindRplc->lpstrFindWhat)+1];  
    char*       pStrPos;
    DWORD       startPos = 0;
    DWORD       endPos   = 0;
    
    SendMessage(hwndEdit, EM_GETSEL, (WPARAM)&startPos, (LPARAM)&endPos);

    if (pFndMem == NULL)
     return -1;

    // Load edit control memory
    GetWindowText (hwndEdit, pFndMem, memLen+1);
    if (!(pFindRplc->Flags & FR_MATCHCASE))
    {
        strlwr (pFndMem);    
        strlwr (pFindRplc->lpstrFindWhat);
    }

    // Determine the direction of the search ...
    if (pFindRplc->Flags & FR_DOWN)
    {
        // Search the document for the find string, downwards
        pStrPos = strstr (pFndMem + endPos, pFindRplc->lpstrFindWhat);                
    }
    else
    {
        // Move upwords ... requires more processing.
        pStrPos = pFndMem + (startPos-1);
        for (;;)
        {
            if (memcmp (pStrPos, pFindRplc->lpstrFindWhat, strlen(pFindRplc->lpstrFindWhat)) == 0)
                 break;
           
            pStrPos--;

            if (pStrPos < pFndMem)
            {
                pStrPos = NULL;
                break;
            }
        }
    }    

    // Return an error code if the string cannot be found
    if (pStrPos == NULL)
    {
        delete[] pFndMem;
        return -1;
    }

    // Find the position in the document and the new start offset
    startPos = pStrPos - pFndMem;
    endPos   = startPos + strlen (pFindRplc->lpstrFindWhat);

    // Select the found text
    SendMessage (hwndEdit, EM_SETSEL, startPos, endPos);
    SendMessage(hwndEdit, EM_SCROLLCARET, 0, 0);
    delete[] pFndMem;
    return startPos;
}

// ----------------------------------------------------------------------------

int ReplaceText (HWND hwndEdit, FINDREPLACE* pFindRplc)
{
    DWORD startPos = 0;
    DWORD endPos   = 0;
    
    SendMessage(hwndEdit, EM_GETSEL, (WPARAM)&startPos, (LPARAM)&endPos);

    // Check that the selected test is the same as the match/replace text
    if ((endPos-startPos) == strlen(pFindRplc->lpstrFindWhat))
    {
        int   memLen  = GetWindowTextLength(hwndEdit);
        char* pFndMem = new char[memLen+strlen(pFindRplc->lpstrFindWhat)+1];      
        char* pStrPos;

        if (pFndMem == NULL)
         return -1;

        // Load edit control memory
        GetWindowText (hwndEdit, pFndMem, memLen+1);
        if (!(pFindRplc->Flags & FR_MATCHCASE))
        {
            strlwr (pFndMem);    
            strlwr (pFindRplc->lpstrFindWhat);
        }

        pStrPos = strstr (pFndMem + startPos, pFindRplc->lpstrFindWhat);                

        // Text found replace it.
        if (pStrPos != NULL)        
        {
            // Select the found text
            SendMessage (hwndEdit, EM_SETSEL, startPos, endPos);
            SendMessage (hwndEdit, EM_REPLACESEL, TRUE, (LPARAM) pFindRplc->lpstrReplaceWith);
            startPos += strlen(pFindRplc->lpstrReplaceWith);
        }

        delete[] pFndMem;
    }   
           
   SendMessage(hwndEdit, EM_SETSEL, (WPARAM)startPos, (LPARAM)startPos);
   SendMessage(hwndEdit, EM_SCROLLCARET, 0, 0);
   return FindText (hwndEdit, pFindRplc);
}
