//**********************************
//******** Print functions *********
//**********************************

#include <windows.h>
#include <commdlg.h>
#include <string.h>
#include <stdio.h>
#include <commdlg.h>
#include <time.h>
#include "resource.h"

// Printer abort 
static BOOL BUserAbort;
static HWND HDlgPrint;

const  char* Months[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", 
                         "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
const  char* Days  [] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };


// ------------------------------------------------------------------------------

BOOL CALLBACK PrintDlgProc (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
        case WM_INITDIALOG:
            EnableMenuItem (GetSystemMenu (hDlg, FALSE), SC_CLOSE, MF_GRAYED);
            return TRUE;

        case WM_COMMAND:
            switch (LOWORD (wParam))
            {
                case IDC_ABORTPRINTJOB:
                    BUserAbort = TRUE;
                    EnableWindow (GetParent (hDlg), TRUE);
                    DestroyWindow (hDlg);
                    HDlgPrint = 0;
                    return TRUE;
            }
    }
    return FALSE;
}          

// ---------------------------------------------------------------------------------

BOOL CALLBACK PrinterAbortProc (HDC hPrinterDC, int nCode)
{
    MSG msg;

    while (!BUserAbort && PeekMessage (&msg, NULL, 0, 0, PM_REMOVE))
    {
         if (!HDlgPrint || !IsDialogMessage (HDlgPrint, &msg))
         {
              TranslateMessage (&msg);
              DispatchMessage (&msg);
         }
    }
    
    return !BUserAbort;
}

// ------------------------------------------------------------------------------

int PrintHeader (char* pageTitle, int pageNum, int charHeight, PRINTDLG* pPrntInfo)
{
    const int  outSize  = 1024;
    SIZE       txtInfo;
    SYSTEMTIME timeInfo;
    char       output[outSize];
    
    sprintf (output, "Sticky : %s  ", pageTitle);

    GetLocalTime(&timeInfo);
    sprintf (output + strlen(output), "%s %s %d %d %d:%d:%d", 
             Days[timeInfo.wDayOfWeek],
             Months[timeInfo.wMonth-1],
             timeInfo.wDay,
             timeInfo.wYear,
             timeInfo.wHour,
             timeInfo.wMinute,
             timeInfo.wSecond);

    TextOut (pPrntInfo -> hDC, 0, 0, (char*) output, (strlen(output)));

    sprintf (output, "[Page %03d] ", pageNum);
    GetTextExtentPoint(pPrntInfo->hDC, (char*)output, strlen(output), &txtInfo);
    TextOut (pPrntInfo -> hDC, GetDeviceCaps (pPrntInfo -> hDC, HORZRES) - txtInfo.cx, 0, (char*) output, strlen(output));

    Rectangle(pPrntInfo -> hDC, 0, 0, GetDeviceCaps (pPrntInfo -> hDC, HORZRES), 1);
    Rectangle(pPrntInfo -> hDC, 0, charHeight-1, GetDeviceCaps (pPrntInfo -> hDC, HORZRES), charHeight);
        
    return 0;
}

// ------------------------------------------------------------------------------

// Returns a string from a edit control.
// idx = 0 to n lines
// return a string that needs to be deleted after use, or null
// if no more lines.
char* GetLine (int idx, HWND hWndSticky)
{
    int   lineOffset;
    int   lineLen;
    char* pNewLine; 

    if ((hWndSticky == NULL) || (idx < 0))
        return NULL;

    // idx out of range
    if (idx >= (SendMessage (hWndSticky,  EM_GETLINECOUNT, 0, 0)))
        return NULL;

    lineOffset = SendMessage (hWndSticky, EM_LINEINDEX,  idx, 0);
    lineLen    = SendMessage (hWndSticky, EM_LINELENGTH, lineOffset, 0);
    if ((pNewLine = new char[lineLen]) == NULL)
        return NULL;

    // Specify the length of the buffer ... what a hack way of parsing a 
    // parameter!
    *((WORD*)pNewLine) = (WORD) lineLen;
    SendMessage (hWndSticky, EM_GETLINE, idx, (LPARAM) (LPCSTR) pNewLine);
    pNewLine[lineLen] = '\0';

    return pNewLine;
}

// --------------------------------------------------------------------------------

int PrntPrintFile (HANDLE hInst, HWND hParentWnd, char* pStickyTitle, HWND hWndSticky, LOGFONT* pPrintFont)
{

    const  char* pJobName = "Sticky print job";
    PRINTDLG     prntInfo;
    BOOL         bSuccess;
    int          charHeight, nCharsPerLine;
    int          nLinesPerPage; 
    TEXTMETRIC   txtMetric;
    DOCINFO      startDocInfo;
    LOGFONT      printFont;
    HFONT        hPrintFont;
    HFONT        hOldFont;  

    // Test sticky data variables...
    if (pStickyTitle == NULL)
        pStickyTitle = "? Unknown Title ?";

    if (hWndSticky == NULL)
    {
        MessageBox (hParentWnd, pStickyTitle, "NULL or No Sticky Data To Print !",  MB_OK | MB_ICONSTOP);
        return TRUE;
    }   

    // Initialise printer select common dialog box.
    memset (&prntInfo, 0, sizeof (PRINTDLG));
    prntInfo.lStructSize         = sizeof (PRINTDLG);
    prntInfo.hwndOwner           = hWndSticky;
    prntInfo.Flags               = PD_ALLPAGES | PD_COLLATE | PD_RETURNDC;
    prntInfo.nFromPage           = 0;
    prntInfo.nToPage             = 0;
    prntInfo.nMinPage            = 0;
    prntInfo.nMaxPage            = 0;
    prntInfo.nCopies             = 1;
 
    if (!PrintDlg (&prntInfo))
         return TRUE;   

    // initialise font system and set correct height info to print system!
    memcpy (&printFont, pPrintFont, sizeof (LOGFONT));
    printFont.lfOutPrecision = OUT_TT_PRECIS | OUT_STROKE_PRECIS;
    printFont.lfHeight       = -MulDiv(printFont.lfHeight, GetDeviceCaps(prntInfo.hDC, LOGPIXELSY), 72);
    hPrintFont               = CreateFontIndirect(&printFont);
    hOldFont                 = SelectObject(prntInfo.hDC, hPrintFont);

    // Get Page size information!    
    GetTextMetrics (prntInfo.hDC, &txtMetric);
    charHeight    = txtMetric.tmHeight + txtMetric.tmExternalLeading;

    nCharsPerLine = GetDeviceCaps (prntInfo.hDC, HORZRES) / txtMetric.tmAveCharWidth;
    nLinesPerPage = GetDeviceCaps (prntInfo.hDC, VERTRES) / charHeight;

    EnableWindow (hParentWnd, FALSE);
    bSuccess      = TRUE;
    BUserAbort    = FALSE;

    // Create abort dialog box ....
    HDlgPrint = CreateDialog (hInst, MAKEINTRESOURCE(IDD_ABORTPRINTDLG), hParentWnd, (DLGPROC) PrintDlgProc);
    SetDlgItemText (HDlgPrint, IDC_STICKYNAME, pStickyTitle);

    // Set the abort procedure active ....
    SetAbortProc(prntInfo.hDC, (ABORTPROC) PrinterAbortProc);

    // Start a document!
    startDocInfo.cbSize      = sizeof (DOCINFO);
    startDocInfo.lpszDocName = pJobName;
    startDocInfo.lpszOutput  = NULL;
    startDocInfo.lpszDatatype= "";
    startDocInfo.fwType      = 0;

    if (StartDoc(prntInfo.hDC, &startDocInfo) > 0)
    {           

        for (int nColCopy = 0;  nColCopy < (prntInfo.Flags & PD_COLLATE ? prntInfo.nCopies : 1); nColCopy++)
        {            
            char*    pLineData       = NULL;
            int      lineNum         = nLinesPerPage;    
            int      pageNum         = 0;
            int      idx             = 0;
                        
            // start processing code ... 
            while ((pLineData = GetLine (idx, hWndSticky)) != NULL)
            {
                if (lineNum >= nLinesPerPage)
                {
                    pageNum++;                          

                    EndPage (prntInfo.hDC);
                    StartPage (prntInfo.hDC);
                    PrintHeader (pStickyTitle, pageNum, charHeight, &prntInfo);
                    lineNum = 2;

                    /* output current page being worked on */
                    SetDlgItemInt(HDlgPrint, IDC_PAGENUM, pageNum, FALSE);
                }

                // Print it!
                TabbedTextOut(prntInfo.hDC, 
                              0, 
                              (lineNum * charHeight), 
                              pLineData, 
                              strlen (pLineData), 
                              0, NULL, 0);

                delete[] pLineData;
                pLineData = NULL;
                lineNum++;
                idx++;
            }
            EndPage (prntInfo.hDC);            
        }
    }
    else
        bSuccess = FALSE;

    // Clean up...        
    if (bSuccess)
    {
        EndPage(prntInfo.hDC);
        EndDoc(prntInfo.hDC);
    }

    if (!BUserAbort)
    {
         EnableWindow (hParentWnd, TRUE);
         DestroyWindow (HDlgPrint);
    }

    // Free up allocated fonts.
    SelectObject (prntInfo.hDC, hOldFont);
    DeleteObject (hPrintFont);
    DeleteDC     (prntInfo.hDC);
    return (bSuccess && !BUserAbort);
}